/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.BEASTVersion2;
import beast.app.util.Utils;
import beast.core.util.ESS;
import beast.core.util.Log;
import beast.util.CollectionUtils;
import beast.util.OutputUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LogAnalyser {
    public static final int BURN_IN_PERCENTAGE = 10;
    protected final String fileName;
    protected String[] m_sLabels;
    protected type[] m_types;
    protected List<String>[] m_ranges;
    protected Double[][] m_fTraces;
    Double[] m_fMean;
    Double[] m_fStdError;
    Double[] m_fStdDev;
    Double[] m_fMedian;
    Double[] m_f95HPDup;
    Double[] m_f95HPDlow;
    Double[] m_fESS;
    Double[] m_fACT;
    Double[] m_fGeometricMean;
    protected String m_sPreAmble;
    protected boolean quiet = false;
    protected static final String BAR = "|---------|---------|---------|---------|---------|---------|---------|---------|";
    final String SPACE = " ";

    public LogAnalyser() {
        this.fileName = null;
    }

    public LogAnalyser(String[] stringArray, int n) throws IOException {
        this(stringArray, n, false, true);
    }

    public LogAnalyser(String[] stringArray, int n, boolean bl, boolean bl2) throws IOException {
        this.fileName = stringArray[stringArray.length - 1];
        this.readLogFile(this.fileName, n);
        this.quiet = bl;
        if (bl2) {
            this.calcStats();
        }
    }

    public LogAnalyser(String[] stringArray) throws IOException {
        this(stringArray, 10, false, true);
    }

    public LogAnalyser(String string, int n) throws IOException {
        this(string, n, false, true);
    }

    public LogAnalyser(String string, int n, boolean bl) throws IOException {
        this(string, n, bl, true);
    }

    public LogAnalyser(String string) throws IOException {
        this(string, 10);
    }

    public LogAnalyser(String string, int n, boolean bl, boolean bl2) throws IOException {
        this.fileName = string;
        this.quiet = bl;
        this.readLogFile(string, n);
        if (bl2) {
            this.calcStats();
        }
    }

    protected void readLogFile(String string, int n) throws IOException {
        int n2;
        String string2;
        this.log("\nLoading " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.m_sPreAmble = "";
        this.m_sLabels = null;
        int n3 = 0;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.indexOf(35) < 0 && string2.matches(".*[0-9a-zA-Z].*")) {
                if (this.m_sLabels == null) {
                    this.m_sLabels = string2.split("\\s");
                    continue;
                }
                ++n3;
                continue;
            }
            this.m_sPreAmble = this.m_sPreAmble + string2 + "\n";
        }
        int n4 = Math.max(1, n3 / 80);
        int n5 = this.m_sLabels.length;
        this.m_ranges = new List[n5];
        int n6 = n3 * n / 100;
        this.m_fTraces = new Double[n5][n3 - n6];
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        n3 = -n6 - 1;
        this.logln(", burnin " + n + "%, skipping " + n6 + " log lines\n\n" + BAR);
        this.m_types = new type[n5];
        Arrays.fill((Object[])this.m_types, (Object)type.INTEGER);
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            n2 = 0;
            if (string2.indexOf(35) < 0 && string2.matches("[0-9].*") && ++n3 >= 0) {
                for (String string3 : string2.split("\\s")) {
                    try {
                        if (string3.indexOf(46) >= 0) {
                            this.m_types[n2] = type.REAL;
                        }
                        this.m_fTraces[n2][n3] = Double.parseDouble(string3);
                    }
                    catch (Exception exception) {
                        if (this.m_ranges[n2] == null) {
                            this.m_ranges[n2] = new ArrayList<String>();
                        }
                        if (!this.m_ranges[n2].contains(string3)) {
                            this.m_ranges[n2].add(string3);
                        }
                        this.m_fTraces[n2][n3] = 1.0 * (double)this.m_ranges[n2].indexOf(string3);
                    }
                    ++n2;
                }
            }
            if (n3 % n4 != 0) continue;
            this.log("*");
        }
        this.logln("");
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.m_ranges[n2] == null) continue;
            this.m_types[n2] = this.m_ranges[n2].size() == 2 && this.m_ranges[n2].contains("true") && this.m_ranges[n2].contains("false") || this.m_ranges[n2].size() == 1 && (this.m_ranges[n2].contains("true") || this.m_ranges[n2].contains("false")) ? type.BOOL : type.NOMINAL;
        }
        bufferedReader.close();
    }

    public void calcStats() {
        this.logln("\nCalculating statistics\n\n|---------|---------|---------|---------|---------|---------|---------|---------|");
        int n = 0;
        int n2 = this.m_sLabels.length;
        this.m_fMean = new Double[n2];
        this.m_fStdError = new Double[n2];
        this.m_fStdDev = new Double[n2];
        this.m_fMedian = new Double[n2];
        this.m_f95HPDlow = new Double[n2];
        this.m_f95HPDup = new Double[n2];
        this.m_fESS = new Double[n2];
        this.m_fACT = new Double[n2];
        this.m_fGeometricMean = new Double[n2];
        int n3 = (int)(this.m_fTraces[0][1] - this.m_fTraces[0][0]);
        for (int i = 1; i < n2; ++i) {
            Object[] objectArray = this.m_fTraces[i];
            double d = 0.0;
            double d2 = 0.0;
            Object[] objectArray2 = objectArray;
            int n4 = objectArray2.length;
            for (int j = 0; j < n4; ++j) {
                double d3 = objectArray2[j];
                d += d3;
                d2 += d3 * d3;
            }
            if (this.m_types[i] != type.NOMINAL) {
                this.m_fMean[i] = d / (double)objectArray.length;
                this.m_fStdDev[i] = Math.sqrt(d2 / (double)objectArray.length - this.m_fMean[i] * this.m_fMean[i]);
            } else {
                this.m_fMean[i] = Double.NaN;
                this.m_fStdDev[i] = Double.NaN;
            }
            if (this.m_types[i] == type.REAL || this.m_types[i] == type.INTEGER) {
                objectArray2 = (Double[])objectArray.clone();
                Arrays.sort(objectArray2);
                this.m_fMedian[i] = objectArray2[objectArray.length / 2];
                n4 = (int)((double)(objectArray2.length - 1) * 95.0 / 100.0);
                double d4 = Double.MAX_VALUE;
                int n5 = 0;
                for (int j = 0; j < objectArray2.length - n4; ++j) {
                    double d5 = (Double)objectArray2[j + n4] - (Double)objectArray2[j];
                    if (!(d5 < d4)) continue;
                    d4 = d5;
                    n5 = j;
                }
                this.m_f95HPDlow[i] = objectArray2[n5];
                this.m_f95HPDup[i] = objectArray2[n5 + n4];
                this.m_fACT[i] = ESS.ACT(this.m_fTraces[i], n3);
                this.m_fStdError[i] = ESS.stdErrorOfMean((Double[])objectArray, n3);
                this.m_fESS[i] = (double)objectArray.length / (this.m_fACT[i] / (double)n3);
                if ((Double)objectArray2[0] > 0.0) {
                    double d6 = 0.0;
                    Object[] objectArray3 = objectArray;
                    int n6 = objectArray3.length;
                    for (int j = 0; j < n6; ++j) {
                        double d7 = (Double)objectArray3[j];
                        d6 += Math.log(d7);
                    }
                    this.m_fGeometricMean[i] = Math.exp(d6 / (double)objectArray.length);
                } else {
                    this.m_fGeometricMean[i] = Double.NaN;
                }
            } else {
                this.m_fMedian[i] = Double.NaN;
                this.m_f95HPDlow[i] = Double.NaN;
                this.m_f95HPDup[i] = Double.NaN;
                this.m_fACT[i] = Double.NaN;
                this.m_fESS[i] = Double.NaN;
                this.m_fGeometricMean[i] = Double.NaN;
            }
            while (n < 80 * (i + 1) / n2) {
                this.log("*");
                ++n;
            }
        }
        this.logln("\n");
    }

    public void setData(Double[][] doubleArray, String[] stringArray, type[] typeArray) {
        this.m_fTraces = (Double[][])doubleArray.clone();
        this.m_sLabels = (String[])stringArray.clone();
        this.m_types = (type[])typeArray.clone();
        this.calcStats();
    }

    public void setData(Double[] doubleArray, int n) {
        Double[][] doubleArray2 = new Double[2][];
        doubleArray2[0] = new Double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray2[0][i] = (double)i * (double)n;
        }
        doubleArray2[1] = (Double[])doubleArray.clone();
        this.setData(doubleArray2, new String[]{"column", "data"}, new type[]{type.REAL, type.REAL});
    }

    public int indexof(String string) {
        return CollectionUtils.indexof(string, this.m_sLabels);
    }

    public List<String> getLabels() {
        if (this.m_sLabels.length < 2) {
            return new ArrayList<String>();
        }
        return CollectionUtils.toList(this.m_sLabels, 1, this.m_sLabels.length);
    }

    public Double[] getTrace(int n) {
        return (Double[])this.m_fTraces[n].clone();
    }

    public Double[] getTrace(String string) {
        return (Double[])this.m_fTraces[this.indexof(string)].clone();
    }

    public double getMean(String string) {
        return this.getMean(this.indexof(string));
    }

    public double getStdError(String string) {
        return this.getStdError(this.indexof(string));
    }

    public double getStdDev(String string) {
        return this.getStdDev(this.indexof(string));
    }

    public double getMedian(String string) {
        return this.getMedian(this.indexof(string));
    }

    public double get95HPDup(String string) {
        return this.get95HPDup(this.indexof(string));
    }

    public double get95HPDlow(String string) {
        return this.get95HPDlow(this.indexof(string));
    }

    public double getESS(String string) {
        return this.getESS(this.indexof(string));
    }

    public double getACT(String string) {
        return this.getACT(this.indexof(string));
    }

    public double getGeometricMean(String string) {
        return this.getGeometricMean(this.indexof(string));
    }

    public double getMean(int n) {
        return this.m_fMean[n];
    }

    public double getStdDev(int n) {
        return this.m_fStdDev[n];
    }

    public double getStdError(int n) {
        return this.m_fStdError[n];
    }

    public double getMedian(int n) {
        return this.m_fMedian[n];
    }

    public double get95HPDup(int n) {
        return this.m_f95HPDup[n];
    }

    public double get95HPDlow(int n) {
        return this.m_f95HPDlow[n];
    }

    public double getESS(int n) {
        return this.m_fESS[n];
    }

    public double getACT(int n) {
        return this.m_fACT[n];
    }

    public double getGeometricMean(int n) {
        return this.m_fGeometricMean[n];
    }

    public double getMean(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_fMean[1];
    }

    public double getStdDev(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_fStdDev[1];
    }

    public double getMedian(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_fMedian[1];
    }

    public double get95HPDup(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_f95HPDup[1];
    }

    public double get95HPDlow(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_f95HPDlow[1];
    }

    public double getESS(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_fESS[1];
    }

    public double getACT(Double[] doubleArray, int n) {
        this.setData(doubleArray, n);
        return this.m_fACT[1];
    }

    public double getGeometricMean(Double[] doubleArray) {
        this.setData(doubleArray, 1);
        return this.m_fGeometricMean[1];
    }

    public String getLogFile() {
        return this.fileName;
    }

    public void print(PrintStream printStream) {
        int n;
        int n2;
        String[] stringArray;
        String string;
        String string2 = System.getProperty("prefix");
        String string3 = string = string2 == null ? "" : "prefix ";
        if (string2 != null && (stringArray = string2.trim().split("\\s+")).length > 1) {
            string = "";
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = string + "prefix" + n2 + " ";
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 0;
        for (n2 = 1; n2 < this.m_sLabels.length; ++n2) {
            n3 = Math.max(this.m_sLabels[n2].length(), n3);
        }
        String string4 = "";
        for (n = 0; n < n3; ++n) {
            string4 = string4 + " ";
        }
        printStream.println("item" + string4.substring(4) + " " + string + OutputUtils.format("mean") + OutputUtils.format("stderr") + OutputUtils.format("stddev") + OutputUtils.format("median") + OutputUtils.format("95%HPDlo") + OutputUtils.format("95%HPDup") + OutputUtils.format("ACT") + OutputUtils.format("ESS") + OutputUtils.format("geometric-mean"));
        for (n = 1; n < this.m_sLabels.length; ++n) {
            printStream.println(this.m_sLabels[n] + string4.substring(this.m_sLabels[n].length()) + " " + (string2 == null ? "" : string2 + " ") + OutputUtils.format(this.m_fMean[n]) + " " + OutputUtils.format(this.m_fStdError[n]) + " " + OutputUtils.format(this.m_fStdDev[n]) + " " + OutputUtils.format(this.m_fMedian[n]) + " " + OutputUtils.format(this.m_f95HPDlow[n]) + " " + OutputUtils.format(this.m_f95HPDup[n]) + " " + OutputUtils.format(this.m_fACT[n]) + " " + OutputUtils.format(this.m_fESS[n]) + " " + OutputUtils.format(this.m_fGeometricMean[n]));
        }
    }

    public void printOneLineHeader(PrintStream printStream) {
        String[] stringArray = new String[]{"mean", "stderr", "stddev", "median", "95%HPDlo", "95%HPDup", "ACT", "ESS", "geometric-mean"};
        for (int i = 1; i < this.m_sLabels.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (i > 1 || j > 0) {
                    printStream.print("\t");
                }
                printStream.print(this.m_sLabels[i] + "." + stringArray[j]);
            }
        }
        printStream.println();
    }

    public void printOneLine(PrintStream printStream) {
        for (int i = 1; i < this.m_sLabels.length; ++i) {
            if (i > 1) {
                printStream.print("\t");
            }
            printStream.print(this.m_fMean[i] + "\t");
            printStream.print(this.m_fStdError[i] + "\t");
            printStream.print(this.m_fStdDev[i] + "\t");
            printStream.print(this.m_fMedian[i] + "\t");
            printStream.print(this.m_f95HPDlow[i] + "\t");
            printStream.print(this.m_f95HPDup[i] + "\t");
            printStream.print(this.m_fACT[i] + "\t");
            printStream.print(this.m_fESS[i] + "\t");
            printStream.print(this.m_fGeometricMean[i]);
        }
        printStream.println();
    }

    protected void log(String string) {
        if (!this.quiet) {
            Log.warning.print(string);
        }
    }

    protected void logln(String string) {
        if (!this.quiet) {
            Log.warning.println(string);
        }
    }

    static void printUsageAndExit() {
        System.out.println("LogAnalyser [-b <burninPercentage] [file1] ... [filen]");
        System.out.println("-burnin <burninPercentage>");
        System.out.println("--burnin <burninPercentage>");
        System.out.println("-b <burninPercentage> percentage of log file to disregard, default 10");
        System.out.println("-oneline Display only one line of output per file.\n         Header is generated from the first file only.\n         (Implies quiet mode.)");
        System.out.println("-quiet Quiet mode.  Avoid printing status updates to stderr.");
        System.out.println("-help");
        System.out.println("--help");
        System.out.println("-h print this message");
        System.out.println("[fileX] log file to analyse. Multiple files are allowed, each is analysed separately");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            Iterator iterator;
            int n = 10;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            block18: while (n2 < stringArray.length) {
                iterator = stringArray[n2];
                switch (iterator) {
                    case "-b": 
                    case "-burnin": 
                    case "--burnin": {
                        if (n2 + 1 >= stringArray.length) {
                            Log.warning.println("-b argument requires another argument");
                            LogAnalyser.printUsageAndExit();
                        }
                        n = Integer.parseInt(stringArray[n2 + 1]);
                        n2 += 2;
                        continue block18;
                    }
                    case "-oneline": {
                        bl = true;
                        ++n2;
                        continue block18;
                    }
                    case "-quiet": {
                        bl2 = true;
                        ++n2;
                        continue block18;
                    }
                    case "-h": 
                    case "-help": 
                    case "--help": {
                        LogAnalyser.printUsageAndExit();
                        continue block18;
                    }
                }
                if (((String)((Object)iterator)).startsWith("-")) {
                    Log.warning.println("unrecognised command " + iterator);
                    LogAnalyser.printUsageAndExit();
                }
                arrayList.add(iterator);
                ++n2;
            }
            if (arrayList.size() == 0) {
                iterator = new BEASTVersion2();
                File file = Utils.getLoadFile("LogAnalyser " + ((BEASTVersion2)((Object)iterator)).getVersionString() + " - Select log file to analyse", null, "BEAST log (*.log) Files", "log", "txt");
                if (file == null) {
                    return;
                }
                LogAnalyser exception = new LogAnalyser(file.getAbsolutePath(), n, bl2);
                exception.print(System.out);
            } else if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    LogAnalyser logAnalyser = new LogAnalyser((String)arrayList.get(i), n, true);
                    if (i == 0) {
                        logAnalyser.printOneLineHeader(System.out);
                    }
                    logAnalyser.printOneLine(System.out);
                }
            } else {
                for (String string : arrayList) {
                    LogAnalyser logAnalyser = new LogAnalyser(string, n, bl2);
                    logAnalyser.print(System.out);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static enum type {
        REAL,
        INTEGER,
        BOOL,
        NOMINAL;

    }
}

