/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.special.Gamma;

@Description(value="Inverse Gamma distribution, used as prior.    for x>0  f(x; alpha, beta) = \frac{beta^alpha}{Gamma(alpha)} (1/x)^{alpha + 1}exp(-beta/x) If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class InverseGamma
extends ParametricDistribution {
    public final Input<RealParameter> alphaInput = new Input("alpha", "shape parameter, defaults to 2");
    public final Input<RealParameter> betaInput = new Input("beta", "scale parameter, defaults to 2");
    InverseGammaImpl dist = new InverseGammaImpl(2.0, 2.0);

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        double d = this.alphaInput.get() == null ? 2.0 : this.alphaInput.get().getValue();
        double d2 = this.betaInput.get() == null ? 2.0 : this.betaInput.get().getValue();
        this.dist.setAlphaBeta(d, d2);
    }

    @Override
    public Distribution getDistribution() {
        this.refresh();
        return this.dist;
    }

    @Override
    public double getMean() {
        return this.betaInput.get().getValue() / (this.alphaInput.get().getValue() - 1.0);
    }

    class InverseGammaImpl
    implements ContinuousDistribution {
        double m_fAlpha;
        double m_fBeta;
        double C;

        InverseGammaImpl(double d, double d2) {
            this.setAlphaBeta(d, d2);
        }

        void setAlphaBeta(double d, double d2) {
            this.m_fAlpha = d;
            this.m_fBeta = d2;
            this.C = this.m_fAlpha * Math.log(this.m_fBeta) - Gamma.logGamma(this.m_fAlpha);
        }

        @Override
        public double cumulativeProbability(double d) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double cumulativeProbability(double d, double d2) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double inverseCumulativeProbability(double d) throws MathException {
            throw new MathException("Not implemented yet", new Object[0]);
        }

        @Override
        public double density(double d) {
            double d2 = this.logDensity(d);
            return Math.exp(d2);
        }

        @Override
        public double logDensity(double d) {
            double d2 = -(this.m_fAlpha + 1.0) * Math.log(d) - this.m_fBeta / d + this.C;
            return d2;
        }
    }
}

