/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.StateNode;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.coalescent.IntervalType;
import beast.evolution.tree.coalescent.PopulationFunction;
import beast.evolution.tree.coalescent.TreeIntervals;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Description(value="An effective population size function based on coalecent times from a set of trees.")
public class CompoundPopulationFunction
extends PopulationFunction.Abstract
implements Loggable {
    public final Input<RealParameter> popSizeParameterInput = new Input("populationSizes", "population value at each point.", Input.Validate.REQUIRED);
    public final Input<BooleanParameter> indicatorsParameterInput = new Input("populationIndicators", "Include/exclude population value from the population function.", Input.Validate.REQUIRED);
    public final Input<List<TreeIntervals>> treesInput = new Input("itree", "Coalecent intervals of this tree are used in the compound population function.", new ArrayList(), Input.Validate.REQUIRED);
    public final Input<String> demographicTypeInput = new Input<String>("type", "Flavour of demographic: either linear or stepwise for  piecewise-linear or piecewise-constant.", "linear");
    public final Input<Boolean> useMiddleInput = new Input<Boolean>("useIntervalsMiddle", "When true, the demographic X axis points are in the middle of the coalescent intervals. By default they are at the beginning.", false);
    private RealParameter popSizeParameter;
    private BooleanParameter indicatorsParameter;
    private List<TreeIntervals> trees;
    private Type type;
    private boolean useMid;
    private double[] values;
    private double[] times;
    private double[] intervals;
    private double[][] ttimes;
    private double[] alltimes;
    private Shadow shadow;

    private void getParams() {
        this.popSizeParameter = this.popSizeParameterInput.get();
        this.indicatorsParameter = this.indicatorsParameterInput.get();
        assert (this.popSizeParameter != null && this.popSizeParameter.getArrayValue(0) > 0.0 && this.indicatorsParameter != null);
    }

    @Override
    public void prepare() {
        this.getParams();
        this.trees = this.treesInput.get();
        this.useMid = this.useMiddleInput.get();
        this.type = Type.valueOf(this.demographicTypeInput.get().toUpperCase());
        int n = 0;
        for (TreeIntervals treeIntervals : this.trees) {
            n += treeIntervals.treeInput.get().getLeafNodeCount() - 1;
        }
        n += this.type == Type.STEPWISE ? 0 : 1;
        try {
            Object object;
            if (this.popSizeParameter.getDimension() != n) {
                object = new RealParameter();
                object.initByName("value", this.popSizeParameter.getValue() + "", "upper", this.popSizeParameter.getUpper(), "lower", this.popSizeParameter.getLower(), "dimension", n);
                ((BEASTObject)object).setID(this.popSizeParameter.getID());
                this.popSizeParameter.assignFromWithoutID((StateNode)object);
            }
            if (this.indicatorsParameter.getDimension() != n - 1) {
                object = new BooleanParameter();
                object.initByName("value", "" + this.indicatorsParameter.getValue(), "dimension", n - 1);
                ((BEASTObject)object).setID(this.indicatorsParameter.getID());
                this.indicatorsParameter.assignFrom((StateNode)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initInternals();
        for (int i = 0; i < this.trees.size(); ++i) {
            this.setTreeTimes(i);
        }
        this.mergeTreeTimes();
        this.setDemographicArrays();
        this.shadow = new Shadow();
    }

    @Override
    public List<String> getParameterIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.popSizeParameter.getID());
        arrayList.add(this.indicatorsParameter.getID());
        for (TreeIntervals treeIntervals : this.trees) {
            arrayList.add(treeIntervals.getID());
        }
        return arrayList;
    }

    @Override
    public double getPopSize(double d) {
        double d2;
        switch (this.type) {
            case STEPWISE: {
                int n = this.getIntervalIndexStep(d);
                d2 = this.values[n];
                break;
            }
            case LINEAR: {
                d2 = this.linPop(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return d2;
    }

    @Override
    public double getIntensity(double d) {
        return this.getIntegral(0.0, d);
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new UnsupportedOperationException();
    }

    private void initInternals() {
        this.ttimes = new double[this.trees.size()][];
        int n = 0;
        for (int i = 0; i < this.ttimes.length; ++i) {
            this.ttimes[i] = new double[this.trees.get((int)i).treeInput.get().getLeafNodeCount() - 1];
            n += this.ttimes[i].length;
        }
        this.alltimes = new double[n];
    }

    private int getIntervalIndexStep(double d) {
        int n = 0;
        float f = (float)d;
        while (f > (float)this.times[n + 1]) {
            ++n;
        }
        return n;
    }

    private int getIntervalIndexLin(double d) {
        int n = 0;
        while (d > this.times[n + 1]) {
            ++n;
        }
        return n;
    }

    private double linPop(double d) {
        int n = this.getIntervalIndexLin(d);
        if (n == this.values.length - 1) {
            return this.values[n];
        }
        double d2 = (d - this.times[n]) / this.intervals[n];
        return d2 * this.values[n + 1] + (1.0 - d2) * this.values[n];
    }

    private double intensityLinInterval(double d, double d2, int n) {
        double d3;
        double d4 = d2 - d;
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = this.values[n];
        double d6 = d3 = n < this.values.length - 1 ? this.values[n + 1] - d5 : 0.0;
        if (d3 == 0.0) {
            return d4 / d5;
        }
        double d7 = this.times[n];
        double d8 = this.intervals[n];
        assert ((float)d <= (float)(d7 + d8) && d >= d7 && (float)d2 <= (float)(d7 + d8) && d2 >= d7);
        double d9 = (d2 - d) / d8 * d3;
        double d10 = d8 * (d5 / d3);
        double d11 = (d10 + (d2 - d7)) / (d10 + (d - d7));
        if (d9 == 0.0 || d11 <= 0.0) {
            double d12 = d5 + (d - d7) / d8 * d3;
            return d4 / d12;
        }
        return d4 * Math.log(d11) / d9;
    }

    private double intensityLinInterval(int n) {
        double d = this.intervals[n];
        double d2 = this.values[n];
        double d3 = this.values[n + 1];
        if (d2 == d3) {
            return d / d2;
        }
        return d * Math.log(d3 / d2) / (d3 - d2);
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = 0.0;
        switch (this.type) {
            case STEPWISE: {
                int n = this.getIntervalIndexStep(d);
                int n2 = this.getIntervalIndexStep(d2);
                double d4 = this.values[n];
                if (n == n2) {
                    d3 = (d2 - d) / d4;
                    break;
                }
                d3 = (this.times[n + 1] - d) / d4;
                for (int i = n + 1; i < n2; ++i) {
                    d3 += this.intervals[i] / this.values[i];
                }
                d3 += (d2 - this.times[n2]) / this.values[n2];
                break;
            }
            case LINEAR: {
                int n = this.getIntervalIndexLin(d);
                int n3 = this.getIntervalIndexLin(d2);
                if (n == n3) {
                    d3 += this.intensityLinInterval(d, d2, n);
                    break;
                }
                d3 += this.intensityLinInterval(d, this.times[n + 1], n);
                for (int i = n + 1; i < n3; ++i) {
                    d3 += this.intensityLinInterval(i);
                }
                d3 += this.intensityLinInterval(this.times[n3], d2, n3);
                break;
            }
        }
        return d3;
    }

    private void setTreeTimes(int n) {
        TreeIntervals treeIntervals = this.trees.get(n);
        treeIntervals.setMultifurcationLimit(0.0);
        int n2 = treeIntervals.getIntervalCount();
        assert (n2 >= this.ttimes[n].length) : n2 + " " + this.ttimes[n].length;
        int n3 = 0;
        for (int i = 0; i < this.ttimes[n].length; ++i) {
            int n4;
            double d = treeIntervals.getInterval(n3);
            while (treeIntervals.getIntervalType(n3) != IntervalType.COALESCENT) {
                d += treeIntervals.getInterval(++n3);
            }
            int n5 = treeIntervals.getLineageCount(n3);
            assert (++n3 != n2 || n5 == 2);
            int n6 = n4 = n3 == n2 ? 1 : treeIntervals.getLineageCount(n3);
            while (n5 <= n4) {
                d += treeIntervals.getInterval(++n3);
                n5 = n4;
                n4 = treeIntervals.getLineageCount(++n3);
            }
            this.ttimes[n][i] = d + (i == 0 ? 0.0 : this.ttimes[n][i - 1]);
        }
    }

    private void mergeTreeTimes() {
        int[] nArray = new int[this.ttimes.length];
        for (int i = 0; i < this.alltimes.length; ++i) {
            int n = 0;
            while (nArray[n] == this.ttimes[n].length) {
                ++n;
            }
            for (int j = n + 1; j < nArray.length; ++j) {
                if (nArray[j] >= this.ttimes[j].length || !(this.ttimes[j][nArray[j]] < this.ttimes[n][nArray[n]])) continue;
                n = j;
            }
            this.alltimes[i] = this.ttimes[n][nArray[n]];
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
    }

    private void setDemographicArrays() {
        int n;
        int n2 = 1;
        int n3 = this.indicatorsParameter.getDimension();
        assert (n3 == this.alltimes.length + (this.type == Type.STEPWISE ? -1 : 0)) : " nd=" + n3 + " alltimes.length=" + this.alltimes.length + " type=" + (Object)((Object)this.type);
        for (n = 0; n < n3; ++n) {
            if (!((Boolean)this.indicatorsParameter.getValue(n)).booleanValue()) continue;
            ++n2;
        }
        this.times = new double[n2 + 1];
        this.values = new double[n2];
        this.intervals = new double[n2 - 1];
        this.times[0] = 0.0;
        this.times[n2] = Double.POSITIVE_INFINITY;
        this.values[0] = (Double)this.popSizeParameter.getValue(0);
        n = 0;
        for (int i = 0; i < n3 && n + 1 < n2; ++i) {
            if (!((Boolean)this.indicatorsParameter.getValue(i)).booleanValue()) continue;
            this.times[n + 1] = this.useMid ? (this.alltimes[i] + (i > 0 ? this.alltimes[i - 1] : 0.0)) / 2.0 : this.alltimes[i];
            this.values[n + 1] = (Double)this.popSizeParameter.getValue(i + 1);
            this.intervals[n] = this.times[n + 1] - this.times[n];
            ++n;
        }
    }

    @Override
    protected void store() {
        super.store();
    }

    @Override
    protected boolean requiresRecalculation() {
        boolean bl = false;
        for (int i = 0; i < this.trees.size(); ++i) {
            TreeIntervals treeIntervals = this.trees.get(i);
            if (!treeIntervals.isDirtyCalculation()) continue;
            this.shadow.protect_ttimes(i);
            this.setTreeTimes(i);
            bl = true;
        }
        this.getParams();
        if (bl) {
            this.shadow.protect_alltimes();
            this.shadow.protect_demo();
            this.mergeTreeTimes();
            this.setDemographicArrays();
        } else {
            if (!this.popSizeParameter.somethingIsDirty() || !this.indicatorsParameter.somethingIsDirty()) {
                // empty if block
            }
            this.shadow.protect_demo();
            this.setDemographicArrays();
        }
        return true;
    }

    @Override
    protected void restore() {
        this.shadow.reject();
        this.shadow.reset();
        super.restore();
    }

    @Override
    protected void accept() {
        this.shadow.accept();
        this.shadow.reset();
        super.accept();
    }

    @Override
    public void init(PrintStream printStream) {
        printStream.print("popsSize0\t");
        for (int i = 0; i < this.alltimes.length; ++i) {
            printStream.print(this.getID() + ".times." + i + "\t");
        }
    }

    @Override
    public void log(int n, PrintStream printStream) {
        printStream.print("0:" + this.popSizeParameter.getArrayValue(0) + "\t");
        for (int i = 0; i < this.alltimes.length - (this.type == Type.STEPWISE ? 1 : 0); ++i) {
            printStream.print(this.alltimes[i]);
            if (this.indicatorsParameter.getArrayValue(i) > 0.0) {
                printStream.print(":" + this.popSizeParameter.getArrayValue(i + 1));
            }
            printStream.print("\t");
        }
        if (this.type == Type.STEPWISE) {
            printStream.print(this.alltimes[this.alltimes.length - 1]);
        }
    }

    @Override
    public void close(PrintStream printStream) {
    }

    static /* synthetic */ double[] access$002(CompoundPopulationFunction compoundPopulationFunction, double[] dArray) {
        compoundPopulationFunction.values = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$102(CompoundPopulationFunction compoundPopulationFunction, double[] dArray) {
        compoundPopulationFunction.times = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$202(CompoundPopulationFunction compoundPopulationFunction, double[] dArray) {
        compoundPopulationFunction.intervals = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$302(CompoundPopulationFunction compoundPopulationFunction, double[] dArray) {
        compoundPopulationFunction.alltimes = dArray;
        return dArray;
    }

    class Shadow {
        double[] values;
        double[] times;
        double[] intervals;
        double[][] ttimes;
        double[] alltimes;
        boolean c_demo;
        boolean c_alltimes;
        boolean[] c_ttimes;

        Shadow() {
            this.values = (double[])CompoundPopulationFunction.this.values.clone();
            this.times = (double[])CompoundPopulationFunction.this.times.clone();
            this.intervals = (double[])CompoundPopulationFunction.this.intervals.clone();
            this.alltimes = (double[])CompoundPopulationFunction.this.alltimes.clone();
            this.ttimes = (double[][])CompoundPopulationFunction.this.ttimes.clone();
            for (int i = 0; i < this.ttimes.length; ++i) {
                this.ttimes[i] = (double[])CompoundPopulationFunction.this.ttimes[i].clone();
            }
            this.c_ttimes = new boolean[this.ttimes.length];
            this.reset();
        }

        void reset() {
            this.c_alltimes = false;
            this.c_demo = false;
            Arrays.fill(this.c_ttimes, false);
        }

        void protect_demo() {
            this.values = CompoundPopulationFunction.this.values;
            this.times = CompoundPopulationFunction.this.times;
            this.intervals = CompoundPopulationFunction.this.intervals;
            CompoundPopulationFunction.access$002(CompoundPopulationFunction.this, null);
            CompoundPopulationFunction.access$102(CompoundPopulationFunction.this, null);
            CompoundPopulationFunction.access$202(CompoundPopulationFunction.this, null);
            this.c_demo = true;
        }

        void protect_alltimes() {
            double[] dArray = CompoundPopulationFunction.this.alltimes;
            System.arraycopy(dArray, 0, this.alltimes, 0, dArray.length);
            this.c_alltimes = true;
        }

        void protect_ttimes(int n) {
            double[] dArray = CompoundPopulationFunction.this.ttimes[n];
            System.arraycopy(dArray, 0, this.ttimes[n], 0, dArray.length);
            this.c_ttimes[n] = true;
        }

        void accept() {
            this.intervals = null;
            this.times = null;
            this.values = null;
        }

        void reject() {
            if (this.c_alltimes) {
                double[] dArray = CompoundPopulationFunction.this.alltimes;
                CompoundPopulationFunction.access$302(CompoundPopulationFunction.this, this.alltimes);
                this.alltimes = dArray;
            }
            if (this.c_demo) {
                CompoundPopulationFunction.access$002(CompoundPopulationFunction.this, this.values);
                CompoundPopulationFunction.access$102(CompoundPopulationFunction.this, this.times);
                CompoundPopulationFunction.access$202(CompoundPopulationFunction.this, this.intervals);
                this.intervals = null;
                this.times = null;
                this.values = null;
            }
            for (int i = 0; i < this.c_ttimes.length; ++i) {
                if (!this.c_ttimes[i]) continue;
                double[] dArray = CompoundPopulationFunction.this.ttimes[i];
                ((CompoundPopulationFunction)CompoundPopulationFunction.this).ttimes[i] = this.ttimes[i];
                this.ttimes[i] = dArray;
            }
        }
    }

    public static enum Type {
        LINEAR("linear"),
        STEPWISE("stepwise");

        String name;

        private Type(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

