/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.datatype.DataType;
import java.util.Arrays;

@Description(value="Represents character frequencies typically used as distribution of the root of the tree. Calculates empirical frequencies of characters in sequence data, or simply assumes a uniform distribution if the estimate flag is set to false.")
public class Frequencies
extends CalculationNode {
    public final Input<Alignment> dataInput = new Input("data", "Sequence data for which frequencies are calculated");
    public final Input<Boolean> estimateInput = new Input<Boolean>("estimate", "Whether to estimate the frequencies from data (true=default) or assume a uniform distribution over characters (false)", true);
    public final Input<RealParameter> frequenciesInput = new Input("frequencies", "A set of frequencies specified as space separated values summing to 1", Input.Validate.XOR, this.dataInput);
    protected double[] freqs;
    boolean needsUpdate;

    @Override
    public void initAndValidate() {
        this.update();
        double d = this.getSumOfFrequencies(this.getFreqs());
        if (Math.abs(d - 1.0) > 1.0E-6) {
            throw new IllegalArgumentException("Frequencies do not add up to 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getFreqs() {
        Frequencies frequencies = this;
        synchronized (frequencies) {
            if (this.needsUpdate) {
                this.update();
            }
        }
        return (double[])this.freqs.clone();
    }

    void update() {
        if (this.frequenciesInput.get() != null) {
            this.freqs = new double[this.frequenciesInput.get().getDimension()];
            for (int i = 0; i < this.freqs.length; ++i) {
                this.freqs[i] = (Double)this.frequenciesInput.get().getValue(i);
            }
        } else if (this.estimateInput.get().booleanValue()) {
            this.estimateFrequencies();
            this.checkFrequencies();
        } else {
            int n = this.dataInput.get().getMaxStateCount();
            this.freqs = new double[n];
            for (int i = 0; i < n; ++i) {
                this.freqs[i] = 1.0 / (double)n;
            }
        }
        this.needsUpdate = false;
    }

    void estimateFrequencies() {
        double d;
        Alignment alignment = this.dataInput.get();
        DataType dataType = alignment.getDataType();
        int n = alignment.getMaxStateCount();
        this.freqs = new double[n];
        Arrays.fill(this.freqs, 1.0 / (double)n);
        int n2 = 0;
        do {
            int n3;
            double[] dArray = new double[n];
            double d2 = 0.0;
            for (n3 = 0; n3 < alignment.getPatternCount(); ++n3) {
                int[] nArray = alignment.getPattern(n3);
                double d3 = alignment.getPatternWeight(n3);
                for (int n4 : nArray) {
                    int[] nArray2 = dataType.getStatesForCode(n4);
                    double d4 = 0.0;
                    for (int n5 : nArray2) {
                        d4 += this.freqs[n5];
                    }
                    for (int n5 : nArray2) {
                        double d5 = this.freqs[n5] * d3 / d4;
                        int n6 = n5;
                        dArray[n6] = dArray[n6] + d5;
                        d2 += d5;
                    }
                }
            }
            d = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += Math.abs(dArray[n3] / d2 - this.freqs[n3]);
                this.freqs[n3] = dArray[n3] / d2;
            }
        } while (d > 1.0E-8 && ++n2 < 1000);
        Log.info.println("Starting frequencies: " + Arrays.toString(this.freqs));
    }

    private void checkFrequencies() {
        double d = 1.0E-10;
        double d2 = 1.0E-10;
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.freqs.length; ++i) {
            double d5 = this.freqs[i];
            if (d5 < d2) {
                this.freqs[i] = d2;
            }
            if (d5 > d4) {
                d4 = d5;
                n = i;
            }
            d3 += this.freqs[i];
        }
        double d6 = 1.0 - d3;
        int n2 = n;
        this.freqs[n2] = this.freqs[n2] + d6;
        for (int i = 0; i < this.freqs.length - 1; ++i) {
            for (int j = i + 1; j < this.freqs.length; ++j) {
                if (this.freqs[i] != this.freqs[j]) continue;
                int n3 = i;
                this.freqs[n3] = this.freqs[n3] + d;
                int n4 = j;
                this.freqs[n4] = this.freqs[n4] - d;
            }
        }
    }

    @Override
    protected boolean requiresRecalculation() {
        boolean bl = false;
        if (this.frequenciesInput.get().somethingIsDirty()) {
            this.needsUpdate = true;
            bl = true;
        }
        return bl;
    }

    private double getSumOfFrequencies(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    @Override
    public void restore() {
        this.needsUpdate = true;
        super.restore();
    }
}

