/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment;

import beast.core.BEASTObject;
import beast.core.Description;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Description(value="For identifying a single taxon")
public class Taxon
extends BEASTObject {
    public Taxon(String string) {
        this.setID(string);
        this.initAndValidate();
    }

    public Taxon() {
    }

    @Override
    public void initAndValidate() {
    }

    protected String toString(String string) {
        return string + this.getID() + "\n";
    }

    public static List<Taxon> createTaxonList(List<String> list) {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        for (String string : list) {
            arrayList.add(new Taxon(string));
        }
        return arrayList;
    }

    public static void assertSameTaxa(String string, Collection<String> collection, String string2, Collection<String> collection2) {
        if (collection.size() != collection2.size()) {
            throw new RuntimeException("Incompatible taxon sets in " + string + " and " + string2);
        }
        for (String string3 : collection) {
            boolean bl = false;
            for (String string4 : collection2) {
                if (!string3.equals(string4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new RuntimeException("Taxon" + string3 + "is not in " + string2);
        }
    }
}

