/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.GeneralParameterList;
import java.util.List;

@Description(value="State node describing a list of real-valued parameters.")
public class RealParameterList
extends GeneralParameterList<Double> {
    public final Input<Double> lowerBoundInput = new Input<Double>("lower", "Lower bound on parameter values.", Double.NEGATIVE_INFINITY);
    public final Input<Double> upperBoundInput = new Input<Double>("upper", "Upper bound on parameter values.", Double.POSITIVE_INFINITY);

    @Override
    public void initAndValidate() {
        this.lowerBound = this.lowerBoundInput.get();
        this.upperBound = this.upperBoundInput.get();
        super.initAndValidate();
    }

    @Override
    protected void readStateFromString(String[] stringArray, List<String[]> list, List<Integer> list2) {
        this.lowerBound = Double.parseDouble(stringArray[0]);
        this.upperBound = Double.parseDouble(stringArray[1]);
        this.pList.clear();
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray2 = list.get(i);
            GeneralParameterList.QuietParameter quietParameter = new GeneralParameterList.QuietParameter();
            quietParameter.key = list2.get(i);
            for (int j = 0; j < stringArray2.length; ++j) {
                quietParameter.values[j] = Double.parseDouble(stringArray2[j]);
            }
            this.pList.add(quietParameter);
        }
    }
}

