/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Description(value="Unordered set mapping keys to values")
public abstract class Map<T>
extends CalculationNode {
    public final Input<java.util.Map<String, T>> defaultInput = new Input("*", "Input containing the map", new LinkedHashMap());
    public java.util.Map<String, T> map;

    public Map() {
        this.defaultInput.setType(this.mapType());
    }

    protected abstract Class<?> mapType();

    @Override
    public void initAndValidate() {
        this.map = this.defaultInput.get();
    }

    @Override
    public void setInputValue(String string, Object object) {
        for (Input<?> input : this.listInputs()) {
            if (input == this.defaultInput || !input.getName().equals(string)) continue;
            input.setValue(object, this);
            return;
        }
        this.map = this.defaultInput.get();
        if (this.defaultInput.getType().equals(List.class)) {
            Object object2;
            if (this.defaultInput.get().containsKey(string)) {
                object2 = (List)this.defaultInput.get().get(string);
                object2.add(object);
            } else {
                object2 = new ArrayList();
                object2.add(object);
                this.defaultInput.get().put(string, object2);
            }
        } else {
            this.defaultInput.get().put(string, object);
        }
    }

    @Override
    public final Input<?> getInput(String string) {
        for (Input<?> input : this.listInputs()) {
            if (input == this.defaultInput || !input.getName().equals(string)) continue;
            return input;
        }
        return this.defaultInput;
    }

    public T get(String string) {
        return this.map.get(string);
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    public T remove(String string) {
        return this.map.remove(string);
    }
}

