/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Param;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

@Description(value="Emulates the behaviour of an Input for constructors annotated with Param annotations.")
public class InputForAnnotatedConstructor<T>
extends Input<T> {
    BEASTInterface beastObject;
    Method getter;
    Method setter;

    public InputForAnnotatedConstructor(BEASTInterface bEASTInterface, Class<?> clazz, Param param) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        if (bEASTInterface == null) {
            throw new NullPointerException();
        }
        this.beastObject = bEASTInterface;
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.theClass = clazz;
        if (param.description().trim().length() == 0) {
            Log.warning.println("Param annotation found without proper description " + param.toString());
        }
        this.tipText = param.description();
        if (this.name == null) {
            throw new NullPointerException();
        }
        this.name = param.name();
        this.rule = param.optional() ? Input.Validate.OPTIONAL : Input.Validate.REQUIRED;
        String string = "get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        try {
            this.getter = bEASTInterface.getClass().getMethod(string, new Class[0]);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            Log.err.println("Programmer error: when getting here an InputType was identified, but no getter for Param annotation found");
            throw exception;
        }
        string = "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        try {
            this.setter = bEASTInterface.getClass().getMethod(string, clazz);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            Log.err.println("Programmer error: when getting here an InputType was identified, but no setter for Param annotation found");
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object object, BEASTInterface bEASTInterface) {
        if (object == null) {
            if (this.value != null && this.value instanceof BEASTInterface) {
                ((BEASTInterface)this.value).getOutputs().remove(bEASTInterface);
            }
            this.setValue(null);
            return;
        }
        if (object instanceof String) {
            try {
                this.setStringValue((String)object);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.warning.println("Failed to set the string value to '" + object + "' for beastobject id=" + bEASTInterface.getID());
                throw new RuntimeException("Failed to set the string value to '" + object + "' for beastobject id=" + bEASTInterface.getID());
            }
        } else if (this.value != null && this.value instanceof List) {
            if (this.theClass.isAssignableFrom(object.getClass())) {
                this.setValue(object);
                if (!(object instanceof BEASTInterface)) return;
                ((BEASTInterface)object).getOutputs().add(bEASTInterface);
                return;
            } else {
                if (!(object instanceof List) || !this.theClass.isAssignableFrom(((List)object).get(0).getClass())) throw new RuntimeException("Input 101: type mismatch for input " + this.getName() + ". " + this.theClass.getName() + ".isAssignableFrom(" + object.getClass() + ")=false");
                for (Object e : (List)object) {
                    this.setValue(e);
                    if (!(e instanceof BEASTInterface)) continue;
                    ((BEASTInterface)e).getOutputs().add(bEASTInterface);
                }
            }
            return;
        } else {
            if (!this.theClass.isAssignableFrom(object.getClass())) throw new RuntimeException("Input 102: type mismatch for input " + this.getName());
            if (object instanceof BEASTInterface) {
                if (this.value != null) {
                    ((BEASTInterface)this.value).getOutputs().remove(bEASTInterface);
                }
                ((BEASTInterface)object).getOutputs().add(bEASTInterface);
            }
            this.setValue(object);
        }
    }

    private void setValue(Object object) {
        try {
            this.setter.invoke((Object)this.beastObject, object);
            if (object instanceof BEASTInterface) {
                ((BEASTInterface)object).getOutputs().add(this.beastObject);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void setStringValue(String string) {
        Object object;
        if (this.value instanceof List) {
            List list = (List)this.get();
            list.clear();
            String string2 = string.replaceAll("^\\s+", "");
            string2 = string2.replaceAll("\\s+$", "");
            String[] stringArray = string2.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.theClass.equals(Integer.class)) {
                    list.add(new Integer(stringArray[i % stringArray.length]));
                    continue;
                }
                if (this.theClass.equals(Double.class)) {
                    list.add(new Double(stringArray[i % stringArray.length]));
                    continue;
                }
                if (this.theClass.equals(Boolean.class)) {
                    String string3 = stringArray[i % stringArray.length].toLowerCase();
                    list.add(string3.equals("1") || string3.equals("true") || string3.equals("yes"));
                    continue;
                }
                if (!this.theClass.equals(String.class)) continue;
                list.add(new String(stringArray[i % stringArray.length]));
            }
            return;
        }
        if (this.theClass.equals(Integer.class)) {
            this.setValue(new Integer(string));
            return;
        }
        if (this.theClass.equals(Double.class)) {
            this.setValue(new Double(string));
            return;
        }
        if (this.theClass.equals(Boolean.class)) {
            object = string.toLowerCase();
            if (((String)object).equals("yes") || ((String)object).equals("true")) {
                this.setValue(Boolean.TRUE);
                return;
            }
            if (((String)object).equals("no") || ((String)object).equals("false")) {
                this.setValue(Boolean.FALSE);
                return;
            }
        }
        if (this.theClass.equals(Function.class)) {
            object = new RealParameter();
            object.initByName("value", string, "upper", 0.0, "lower", 0.0, "dimension", 1);
            ((RealParameter)object).initAndValidate();
            this.setValue(object);
            ((BEASTObject)object).getOutputs().add(this.beastObject);
            return;
        }
        if (this.theClass.isEnum()) {
            if (this.possibleValues == null) {
                this.possibleValues = this.theClass.getDeclaringClass().getEnumConstants();
            }
            for (Object object2 : this.possibleValues) {
                if (!string.equals(object2.toString())) continue;
                this.setValue(object2);
                return;
            }
            throw new IllegalArgumentException("Input 104: value " + string + " not found. Select one of " + Arrays.toString(this.possibleValues));
        }
        try {
            Object object3 = string;
            try {
                object = this.theClass.getDeclaredConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object3 = string.startsWith("0x") ? Integer.valueOf(Integer.parseInt(string.substring(2), 16)) : Integer.valueOf(Integer.parseInt(string));
                    object = this.theClass.getDeclaredConstructor(Integer.TYPE);
                }
                catch (NumberFormatException numberFormatException) {
                    object3 = Double.parseDouble(string);
                    object = this.theClass.getDeclaredConstructor(Double.TYPE);
                }
            }
            ((Constructor)object).setAccessible(true);
            Object t = ((Constructor)object).newInstance(object3);
            this.setValue(t);
            if (t instanceof BEASTInterface) {
                ((BEASTInterface)t).getOutputs().add(this.beastObject);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input 103: type mismatch, cannot initialize input '" + this.getName() + "' with value '" + string + "'.\nExpected something of type " + this.getType().getName() + ". " + (exception.getMessage() != null ? exception.getMessage() : ""));
        }
    }

    @Override
    public T get() {
        try {
            return (T)this.getter.invoke((Object)this.beastObject, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }
}

