/*
 * Decompiled with CFR 0.152.
 */
package beast.app.tools;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TableEditorStopper
extends FocusAdapter
implements PropertyChangeListener {
    private Component focused;
    private JTable table;

    public static void ensureEditingStopWhenTableLosesFocus(JTable jTable) {
        new TableEditorStopper(jTable);
    }

    private TableEditorStopper(JTable jTable) {
        this.table = jTable;
        jTable.addPropertyChangeListener("tableCellEditor", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.focused != null) {
            this.focused.removeFocusListener(this);
        }
        this.focused = this.table.getEditorComponent();
        if (this.focused != null) {
            this.focused.addFocusListener(this);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.focused != null) {
            this.focused.removeFocusListener(this);
            this.focused = focusEvent.getOppositeComponent();
            if (this.table == this.focused || this.table.isAncestorOf(this.focused)) {
                this.focused.addFocusListener(this);
            } else {
                this.focused = null;
                TableCellEditor tableCellEditor = this.table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
            }
        }
    }
}

