/*
 * Decompiled with CFR 0.152.
 */
package beast.app.seqgen;

import beast.app.seqgen.MergeDataWith;
import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.Input;
import beast.core.Runnable;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.datatype.DataType;
import beast.evolution.likelihood.TreeLikelihood;
import beast.evolution.sitemodel.SiteModel;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import beast.util.XMLParser;
import beast.util.XMLParserException;
import beast.util.XMLProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Description(value="Performs random sequence generation for a given site model. Sequences for the leave nodes in the tree are returned as an alignment.")
public class SequenceSimulator
extends Runnable {
    public final Input<Alignment> m_data = new Input("data", "alignment data which specifies datatype and taxa of the beast.tree", Input.Validate.REQUIRED);
    public final Input<Tree> m_treeInput = new Input("tree", "phylogenetic beast.tree with sequence data in the leafs", Input.Validate.REQUIRED);
    public final Input<SiteModelInterface.Base> m_pSiteModelInput = new Input("siteModel", "site model for leafs in the beast.tree", Input.Validate.REQUIRED);
    public final Input<BranchRateModel.Base> m_pBranchRateModelInput = new Input("branchRateModel", "A model describing the rates on the branches of the beast.tree.");
    public final Input<Integer> m_sequenceLengthInput = new Input<Integer>("sequencelength", "nr of samples to generate (default 1000).", 1000);
    public final Input<String> m_outputFileNameInput = new Input("outputFileName", "If provided, simulated alignment is written to this file rather than to standard out.");
    public final Input<List<MergeDataWith>> mergeListInput = new Input("merge", "specifies template used to merge the generated alignment with", new ArrayList());
    public final Input<Integer> iterationsInput = new Input<Integer>("iterations", "number of times the data is generated", 1);
    protected int m_sequenceLength;
    protected Tree m_tree;
    protected SiteModelInterface.Base m_siteModel;
    protected BranchRateModel m_branchRateModel;
    int m_categoryCount;
    int m_stateCount;
    String m_outputFileName;
    protected double[][] m_probabilities;

    @Override
    public void initAndValidate() {
        this.m_tree = this.m_treeInput.get();
        this.m_siteModel = this.m_pSiteModelInput.get();
        this.m_branchRateModel = this.m_pBranchRateModelInput.get();
        this.m_sequenceLength = this.m_sequenceLengthInput.get();
        this.m_stateCount = this.m_data.get().getMaxStateCount();
        this.m_categoryCount = this.m_siteModel.getCategoryCount();
        this.m_probabilities = new double[this.m_categoryCount][this.m_stateCount * this.m_stateCount];
        this.m_outputFileName = this.m_outputFileNameInput.get();
    }

    @Override
    public void run() throws IllegalArgumentException, IllegalAccessException, IOException, XMLParserException {
        for (int i = 0; i < this.iterationsInput.get(); ++i) {
            Alignment alignment = this.simulate();
            PrintStream printStream = this.m_outputFileName == null ? System.out : new PrintStream(this.m_outputFileName);
            printStream.println(new XMLProducer().toRawXML(alignment));
            for (MergeDataWith mergeDataWith : this.mergeListInput.get()) {
                mergeDataWith.process(alignment, i);
            }
        }
    }

    Sequence intArray2Sequence(int[] nArray, Node node) {
        DataType dataType = this.m_data.get().getDataType();
        String string = dataType.state2string(nArray);
        List<Sequence> list = this.m_data.get().sequenceInput.get();
        String string2 = list.get((int)node.getNr()).taxonInput.get();
        return new Sequence(string2, string);
    }

    public Alignment simulate() {
        Node node = this.m_tree.getRoot();
        double[] dArray = this.m_siteModel.getCategoryProportions(node);
        int[] nArray = new int[this.m_sequenceLength];
        for (int i = 0; i < this.m_sequenceLength; ++i) {
            nArray[i] = Randomizer.randomChoicePDF(dArray);
        }
        double[] dArray2 = this.m_siteModel.getSubstitutionModel().getFrequencies();
        int[] nArray2 = new int[this.m_sequenceLength];
        for (int i = 0; i < this.m_sequenceLength; ++i) {
            nArray2[i] = Randomizer.randomChoicePDF(dArray2);
        }
        Alignment alignment = new Alignment();
        alignment.userDataTypeInput.setValue(this.m_data.get().getDataType(), alignment);
        alignment.setID("SequenceSimulator");
        this.traverse(node, nArray2, nArray, alignment);
        return alignment;
    }

    void traverse(Node node, int[] nArray, int[] nArray2, Alignment alignment) {
        for (int i = 0; i < 2; ++i) {
            Node node2 = i == 0 ? node.getLeft() : node.getRight();
            for (int j = 0; j < this.m_categoryCount; ++j) {
                this.getTransitionProbabilities(this.m_tree, node2, j, this.m_probabilities[j]);
            }
            int[] nArray3 = new int[this.m_sequenceLength];
            double[] dArray = new double[this.m_stateCount];
            for (int j = 0; j < this.m_sequenceLength; ++j) {
                System.arraycopy(this.m_probabilities[nArray2[j]], nArray[j] * this.m_stateCount, dArray, 0, this.m_stateCount);
                nArray3[j] = Randomizer.randomChoicePDF(dArray);
            }
            if (node2.isLeaf()) {
                alignment.sequenceInput.setValue(this.intArray2Sequence(nArray3, node2), alignment);
                continue;
            }
            this.traverse(node2, nArray3, nArray2, alignment);
        }
    }

    void getTransitionProbabilities(Tree tree, Node node, int n, double[] dArray) {
        Node node2 = node.getParent();
        double d = this.m_branchRateModel == null ? 1.0 : this.m_branchRateModel.getRateForBranch(node);
        this.m_siteModel.getSubstitutionModel().getTransitionProbabilities(node, node2.getHeight(), node.getHeight(), d *= this.m_siteModel.getRateForCategory(n, node), dArray);
    }

    static TreeLikelihood getTreeLikelihood(BEASTInterface bEASTInterface) {
        for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
            if (bEASTInterface2 instanceof TreeLikelihood) {
                return (TreeLikelihood)bEASTInterface2;
            }
            TreeLikelihood treeLikelihood = SequenceSimulator.getTreeLikelihood(bEASTInterface2);
            if (treeLikelihood == null) continue;
            return treeLikelihood;
        }
        return null;
    }

    public static void printUsageAndExit() {
        System.out.println("Usage: java " + SequenceSimulator.class.getName() + " <beast file> <nr of instantiations> [<output file>]");
        System.out.println("simulates from a treelikelihood specified in the beast file.");
        System.out.println("<beast file> is name of the path beast file containing the treelikelihood.");
        System.out.println("<nr of instantiations> is the number of instantiations to be replicated.");
        System.out.println("<output file> optional name of the file to write the sequence to. By default, the sequence is written to standard output.");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            if (stringArray.length < 2) {
                SequenceSimulator.printUsageAndExit();
            }
            String string = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            PrintStream printStream = System.out;
            if (stringArray.length == 3) {
                object = new File(stringArray[2]);
                printStream = new PrintStream((File)object);
            }
            object = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready()) {
                object = (String)object + bufferedReader.readLine();
            }
            bufferedReader.close();
            XMLParser xMLParser = new XMLParser();
            BEASTInterface bEASTInterface = xMLParser.parseFragment((String)object, true);
            TreeLikelihood treeLikelihood = SequenceSimulator.getTreeLikelihood(bEASTInterface);
            if (treeLikelihood == null) {
                throw new IllegalArgumentException("No treelikelihood found in file. Giving up now.");
            }
            Alignment alignment = (Alignment)treeLikelihood.getInput("data").get();
            Tree tree = (Tree)treeLikelihood.getInput("tree").get();
            SiteModel siteModel = (SiteModel)treeLikelihood.getInput("siteModel").get();
            BranchRateModel branchRateModel = (BranchRateModel)treeLikelihood.getInput("branchRateModel").get();
            SequenceSimulator sequenceSimulator = new SequenceSimulator();
            sequenceSimulator.init(alignment, tree, siteModel, branchRateModel, n);
            XMLProducer xMLProducer = new XMLProducer();
            Alignment alignment2 = sequenceSimulator.simulate();
            object = xMLProducer.toRawXML(alignment2);
            printStream.println("<beast version='2.0'>");
            printStream.println((String)object);
            printStream.println("</beast>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

