/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.TagExtractor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TagExtractorTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testTagExtractor() {
        TagExtractor extractor = new TagExtractor(null, 0);
        Assert.assertEquals((Object)extractor.target_, null);
        Assert.assertEquals((long)extractor.threshold_, (long)0L);
        TagExtractor extractor2 = new TagExtractor("abstract", 10);
        Assert.assertEquals((Object)extractor2.target_, (Object)"abstract");
        Assert.assertEquals((long)extractor2.threshold_, (long)10L);
    }

    @Test
    public final void testSetTag() {
        TagExtractor extractor = new TagExtractor(null, 0);
        extractor.setTag("");
        Assert.assertEquals((Object)extractor.tag_, (Object)"");
        extractor.setTag(null);
        Assert.assertEquals((Object)extractor.tag_, null);
    }

    @Test
    public final void testAdd() {
        TagExtractor extractor = new TagExtractor(null, 0);
        extractor.add("");
        extractor.add(null);
    }

    @Test
    public final void testCloseTag() {
        TagExtractor extractor = new TagExtractor(null, 0);
        extractor.closeTag();
    }

    @Test
    public final void testNormalScenario() {
        TagExtractor extractor = new TagExtractor("abstract", 10);
        Assert.assertEquals((long)extractor.count(), (long)0L);
        LangProfile profile = new LangProfile("en");
        extractor.setTag("abstract");
        extractor.add("This is a sample text.");
        profile.update(extractor.closeTag());
        Assert.assertEquals((long)extractor.count(), (long)1L);
        Assert.assertEquals((long)profile.n_words[0], (long)17L);
        Assert.assertEquals((long)profile.n_words[1], (long)22L);
        Assert.assertEquals((long)profile.n_words[2], (long)17L);
        extractor.setTag("abstract");
        extractor.add("sample");
        profile.update(extractor.closeTag());
        Assert.assertEquals((long)extractor.count(), (long)1L);
        extractor.setTag("div");
        extractor.add("This is a sample text which is enough long.");
        profile.update(extractor.closeTag());
        Assert.assertEquals((long)extractor.count(), (long)1L);
    }

    @Test
    public final void testClear() {
        TagExtractor extractor = new TagExtractor("abstract", 10);
        extractor.setTag("abstract");
        extractor.add("This is a sample text.");
        Assert.assertEquals((Object)extractor.buf_.toString(), (Object)"This is a sample text.");
        Assert.assertEquals((Object)extractor.tag_, (Object)"abstract");
        extractor.clear();
        Assert.assertEquals((Object)extractor.buf_.toString(), (Object)"");
        Assert.assertEquals((Object)extractor.tag_, null);
    }
}

