/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.MapListener;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialPrefixTreeFieldType<T extends PrefixTreeStrategy>
extends AbstractSpatialFieldType<T> {
    public static final String DEFAULT_FIELD_VALUES_ARRAY_LEN = "defaultFieldValuesArrayLen";
    protected SpatialPrefixTree grid;
    private Double distErrPct;
    private Integer defaultFieldValuesArrayLen;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        if (args.containsKey("maxDistErr")) {
            double maxDistErrOriginal = Double.parseDouble(args.get("maxDistErr"));
            args.put("maxDistErr", Double.toString(maxDistErrOriginal * this.distanceUnits.multiplierFromThisUnitToDegrees()));
        }
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.grid = SpatialPrefixTreeFactory.makeSPT(argsWrap, (ClassLoader)schema.getResourceLoader().getClassLoader(), (SpatialContext)this.ctx);
        args.keySet().removeAll(argsWrap.getSeenKeys());
        String v = args.remove("distErrPct");
        if (v != null) {
            this.distErrPct = Double.valueOf(v);
        }
        if ((v = args.remove(DEFAULT_FIELD_VALUES_ARRAY_LEN)) != null) {
            this.defaultFieldValuesArrayLen = Integer.valueOf(v);
        }
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(final String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new KeywordTokenizer()){
                    private Shape shape;
                    {
                        super(x0);
                        this.shape = null;
                    }

                    protected void setReader(Reader reader) {
                        this.source.setReader(reader);
                        try {
                            this.shape = AbstractSpatialPrefixTreeFieldType.this.parseShape(IOUtils.toString((Reader)reader));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public TokenStream getTokenStream() {
                        Object s = AbstractSpatialPrefixTreeFieldType.this.newSpatialStrategy(fieldName == null ? AbstractSpatialPrefixTreeFieldType.this.getTypeName() : fieldName);
                        return s.createIndexableFields(this.shape)[0].tokenStreamValue();
                    }
                };
            }
        };
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.getIndexAnalyzer();
    }

    @Override
    protected T newSpatialStrategy(String fieldName) {
        T strat = this.newPrefixTreeStrategy(fieldName);
        if (this.distErrPct != null) {
            strat.setDistErrPct(this.distErrPct.doubleValue());
        }
        if (this.defaultFieldValuesArrayLen != null) {
            strat.setDefaultFieldValuesArrayLen(this.defaultFieldValuesArrayLen.intValue());
        }
        log.info(this.toString() + " strat: " + strat + " maxLevels: " + this.grid.getMaxLevels());
        return strat;
    }

    protected abstract T newPrefixTreeStrategy(String var1);
}

