/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        Map prevColAliases = zkStateReader.getAliases().getCollectionAliasMap();
        this.validateAllCollectionsExist(collections, prevColAliases, zkStateReader.getClusterState());
        HashMap newAliasesMap = new HashMap();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = Utils.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void validateAllCollectionsExist(String collections, Map<String, String> prevColAliases, ClusterState clusterState) {
        String[] collectionArr;
        for (String collection : collectionArr = collections.split(",")) {
            if (clusterState.getCollectionOrNull(collection) != null || prevColAliases != null && prevColAliases.containsKey(collection)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', '%s' is not an existing collection or alias", collections, collection));
        }
    }

    private void checkForAlias(String name, String value) {
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean success = false;
        while (!timeout.hasTimedOut()) {
            Aliases aliases = this.ocmh.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }
}

