/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private static final boolean DEBUG = false;
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private Class[] optionalAuxiliaryClasses = null;
    private AuxiliaryClassLoader classLoader = null;
    private IClassLoader iClassLoader = null;
    private ClassLoader result = null;
    protected boolean debugSource;
    protected boolean debugLines = this.debugSource = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    protected boolean debugVars = this.debugSource;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$codehaus$janino$SimpleCompiler;

    public static void main(String[] args) throws Exception {
        if (args.length >= 1 && args[0].equals("-help")) {
            System.out.println("Usage:");
            System.out.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> { <argument> }");
            System.out.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.out.println("\"public static void main(String[])\" of class <class-name>, passing the.");
            System.out.println("given <argument>s.");
            System.exit(1);
        }
        if (args.length < 2) {
            System.err.println("Source file and/or class name missing; try \"-help\".");
            System.exit(1);
        }
        String sourceFileName = args[0];
        String className = args[1];
        String[] arguments = new String[args.length - 2];
        System.arraycopy(args, 2, arguments, 0, arguments.length);
        ClassLoader cl = new SimpleCompiler(sourceFileName, new FileInputStream(sourceFileName)).getClassLoader();
        Class<?> c = cl.loadClass(className);
        Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = SimpleCompiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        m.invoke(null, new Object[]{arguments});
    }

    public SimpleCompiler(String optionalFileName, Reader in) throws IOException, CompileException {
        this.cook(optionalFileName, in);
    }

    public SimpleCompiler(String optionalFileName, InputStream is) throws IOException, CompileException {
        this.cook(optionalFileName, is);
    }

    public SimpleCompiler(String fileName) throws IOException, CompileException {
        this.cookFile(fileName);
    }

    public SimpleCompiler(Scanner scanner, ClassLoader optionalParentClassLoader) throws IOException, CompileException {
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public SimpleCompiler() {
    }

    public void setParentClassLoader(ClassLoader optionalParentClassLoader) {
        this.setParentClassLoader(optionalParentClassLoader, null);
    }

    public void setParentClassLoader(ClassLoader optionalParentClassLoader, Class[] auxiliaryClasses) {
        this.assertNotCooked();
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
        this.optionalAuxiliaryClasses = auxiliaryClasses;
    }

    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public final void cook(String optionalFileName, Reader r) throws CompileException, IOException {
        this.cook(new Scanner(optionalFileName, r));
    }

    public void cook(Scanner scanner) throws CompileException, IOException {
        this.setUpClassLoaders();
        Java.CompilationUnit compilationUnit = new Parser(scanner).parseCompilationUnit();
        this.compileToClassLoader(compilationUnit);
    }

    public void cook(Java.CompilationUnit compilationUnit) throws CompileException {
        this.setUpClassLoaders();
        this.compileToClassLoader(compilationUnit);
    }

    protected final void setUpClassLoaders() {
        this.assertNotCooked();
        this.classLoader = (AuxiliaryClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new AuxiliaryClassLoader(SimpleCompiler.this.parentClassLoader);
            }
        });
        if (this.optionalAuxiliaryClasses != null) {
            for (int i = 0; i < this.optionalAuxiliaryClasses.length; ++i) {
                this.classLoader.addAuxiliaryClass(this.optionalAuxiliaryClasses[i]);
            }
        }
        this.iClassLoader = new ClassLoaderIClassLoader(this.classLoader);
    }

    public ClassLoader getClassLoader() {
        if (((Object)((Object)this)).getClass() != (class$org$codehaus$janino$SimpleCompiler == null ? (class$org$codehaus$janino$SimpleCompiler = SimpleCompiler.class$("org.codehaus.janino.SimpleCompiler")) : class$org$codehaus$janino$SimpleCompiler)) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler that = (SimpleCompiler)((Object)o);
        if (((Object)((Object)this)).getClass() != ((Object)((Object)that)).getClass()) {
            return false;
        }
        if (this.result == null || that.result == null) {
            throw new IllegalStateException("Equality can only be checked after cooking");
        }
        return this.result.equals(that.result);
    }

    public int hashCode() {
        return this.classLoader.hashCode();
    }

    protected Java.Type classToType(Location location, Class optionalClass) {
        IClass iClass;
        if (optionalClass == null) {
            return null;
        }
        this.classLoader.addAuxiliaryClass(optionalClass);
        try {
            iClass = this.iClassLoader.loadIClass(Descriptor.fromClassName(optionalClass.getName()));
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading IClass \"" + optionalClass.getName() + "\": " + ex);
        }
        if (iClass == null) {
            throw new JaninoRuntimeException("Cannot load class \"" + optionalClass.getName() + "\" through the given ClassLoader");
        }
        return new Java.SimpleType(location, iClass);
    }

    protected Java.Type[] classesToTypes(Location location, Class[] classes) {
        Java.Type[] types = new Java.Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = this.classToType(location, classes[i]);
        }
        return types;
    }

    protected final ClassLoader compileToClassLoader(Java.CompilationUnit compilationUnit) throws CompileException {
        ClassFile[] classFiles = new UnitCompiler(compilationUnit, this.iClassLoader).compileUnit(this.debugSource, this.debugLines, this.debugVars);
        final HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (int i = 0; i < classFiles.length; ++i) {
            ClassFile cf = classFiles[i];
            classes.put(cf.getThisClassName(), cf.toByteArray());
        }
        this.result = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ByteArrayClassLoader(classes, (ClassLoader)SimpleCompiler.this.classLoader);
            }
        });
        return this.result;
    }

    protected void assertNotCooked() {
        if (this.classLoader != null) {
            throw new IllegalStateException("Already cooked");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class AuxiliaryClassLoader
    extends ClassLoader {
        private final Map auxiliaryClasses = new HashMap();

        private AuxiliaryClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class c = (Class)this.auxiliaryClasses.get(name);
            if (c != null) {
                return c;
            }
            return super.loadClass(name, resolve);
        }

        private void addAuxiliaryClass(Class c) {
            if (this.auxiliaryClasses.containsKey(c.getName())) {
                return;
            }
            try {
                Class<?> c2 = super.loadClass(c.getName(), false);
                if (c2 != c) {
                    throw new JaninoRuntimeException("Trying to add an auxiliary class \"" + c.getName() + "\" while another class with the same name is already loaded");
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            this.auxiliaryClasses.put(c.getName(), c);
            Class sc = c.getSuperclass();
            if (sc != null) {
                this.addAuxiliaryClass(sc);
            }
            Class<?>[] ifs = c.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                this.addAuxiliaryClass(ifs[i]);
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuxiliaryClassLoader)) {
                return false;
            }
            AuxiliaryClassLoader that = (AuxiliaryClassLoader)o;
            ClassLoader parentOfThis = this.getParent();
            ClassLoader parentOfThat = that.getParent();
            if (parentOfThis == null ? parentOfThat != null : !parentOfThis.equals(parentOfThat)) {
                return false;
            }
            return ((Object)this.auxiliaryClasses).equals(that.auxiliaryClasses);
        }

        public int hashCode() {
            ClassLoader parent = this.getParent();
            return (parent == null ? 0 : parent.hashCode()) ^ ((Object)this.auxiliaryClasses).hashCode();
        }
    }
}

