/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.widget.PieceSlot;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.imports.ImportAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class Importer {
    protected ImportAction action;
    protected File file;

    protected static void insertComponent(Buildable buildable, Buildable buildable2) {
        buildable.build(null);
        if (buildable instanceof PieceSlot) {
            ((PieceSlot)buildable).updateGpId(GameModule.getGameModule());
        }
        buildable.addTo(buildable2);
        buildable2.add(buildable);
    }

    protected Map getMainMap() {
        return GameModule.getGameModule().getAllDescendantComponentsOf(Map.class).iterator().next();
    }

    protected LayeredPieceCollection getLayeredPieceCollection() {
        Map map = this.getMainMap();
        List<LayeredPieceCollection> list = map.getComponentsOf(LayeredPieceCollection.class);
        LayeredPieceCollection layeredPieceCollection = null;
        if (list.size() == 0) {
            layeredPieceCollection = new LayeredPieceCollection();
            Importer.insertComponent(layeredPieceCollection, map);
            layeredPieceCollection.setAttribute("property", "Layer");
        } else {
            assert (list.size() == 1);
            layeredPieceCollection = list.get(0);
        }
        return layeredPieceCollection;
    }

    protected void load(File file) throws IOException {
        this.file = file;
    }

    public abstract void writeToArchive() throws IOException;

    public void importFile(ImportAction importAction, File file) throws IOException {
        this.action = importAction;
        this.load(file);
    }

    public static String stripExtension(String string) {
        if (string.equals(".") || string.equals("..")) {
            return string;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n < n2) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String readWindowsFileName(InputStream inputStream) throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((c = (char)inputStream.read()) == '\\') {
                stringBuilder.append(File.separatorChar);
                continue;
            }
            if (c == '\u0000') continue;
            stringBuilder.append(c);
        } while (c != '\u0000');
        return stringBuilder.toString();
    }

    public static String readNullTerminatedString(InputStream inputStream, int n) throws IOException {
        StringBuilder stringBuilder = n == 0 ? new StringBuilder() : new StringBuilder(n);
        for (int i = 0; n == 0 || i < n; ++i) {
            char c = (char)inputStream.read();
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            if (c == '\u0000') break;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String readNullTerminatedString(InputStream inputStream) throws IOException {
        return Importer.readNullTerminatedString(inputStream, 0);
    }

    public static String getUniqueImageFileName(String string, String string2) {
        String string3 = string;
        int n = 0;
        ArchiveWriter archiveWriter = GameModule.getGameModule().getArchiveWriter();
        try {
            while (archiveWriter.contains(archiveWriter.getImagePrefix() + string3 + string2)) {
                string3 = string + '(' + ++n + ')';
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string3 + string2;
    }

    public static String getUniqueImageFileName(String string) {
        return Importer.getUniqueImageFileName(string, ".png");
    }

    public static String getFileName(String string) {
        if (string.equals(".") || string.equals("..")) {
            return string;
        }
        int n = string.lastIndexOf(File.separatorChar);
        return string.substring(n + 1, string.length());
    }

    public static String getExtension(String string) {
        if (string.equals(".") || string.equals("..")) {
            return "";
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n < n2 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String forceExtension(String string, String string2) {
        if (string.equals(".") || string.equals("..")) {
            return string;
        }
        return Importer.stripExtension(string) + '.' + string2;
    }

    public abstract boolean isValidImportFile(File var1) throws IOException;
}

