/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.opcache.OpCache;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpImpl
extends VASSAL.tools.opcache.AbstractOpImpl<BufferedImage>
implements ImageOp {
    protected Dimension size;
    protected static final OpCache cache = new OpCache();

    public static void clearCache() {
        cache.clear();
    }

    public AbstractOpImpl() {
        super(cache);
    }

    @Override
    public abstract BufferedImage eval() throws Exception;

    @Override
    public BufferedImage getImage() {
        block4: {
            try {
                return this.getImage(null);
            }
            catch (CancellationException cancellationException) {
                ErrorDialog.bug(cancellationException);
            }
            catch (InterruptedException interruptedException) {
                ErrorDialog.bug(interruptedException);
            }
            catch (ExecutionException executionException) {
                if (Op.handleException(executionException)) break block4;
                ErrorDialog.bug(executionException);
            }
        }
        return null;
    }

    @Override
    public BufferedImage getImage(ImageOpObserver imageOpObserver) throws CancellationException, InterruptedException, ExecutionException {
        return this.get(imageOpObserver);
    }

    @Override
    public Future<BufferedImage> getFutureImage(ImageOpObserver imageOpObserver) throws ExecutionException {
        return this.getFuture(imageOpObserver);
    }

    protected Dimension getSizeFromCache() {
        BufferedImage bufferedImage = (BufferedImage)cache.getIfDone(this.newKey());
        return bufferedImage == null ? null : new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected abstract void fixSize();

    @Override
    public Dimension getSize() {
        if (this.size == null) {
            this.fixSize();
        }
        return new Dimension(this.size);
    }

    @Override
    public int getWidth() {
        if (this.size == null) {
            this.fixSize();
        }
        return this.size.width;
    }

    @Override
    public int getHeight() {
        if (this.size == null) {
            this.fixSize();
        }
        return this.size.height;
    }

    @Override
    public abstract Dimension getTileSize();

    @Override
    public abstract int getTileHeight();

    @Override
    public abstract int getTileWidth();

    @Override
    public abstract int getNumXTiles();

    @Override
    public abstract int getNumYTiles();

    @Override
    public BufferedImage getTile(Point point, ImageOpObserver imageOpObserver) throws CancellationException, InterruptedException, ExecutionException {
        return this.getTile(point.x, point.y, imageOpObserver);
    }

    @Override
    public abstract BufferedImage getTile(int var1, int var2, ImageOpObserver var3) throws CancellationException, InterruptedException, ExecutionException;

    @Override
    public Future<BufferedImage> getFutureTile(Point point, ImageOpObserver imageOpObserver) throws ExecutionException {
        return this.getFutureTile(point.x, point.y, imageOpObserver);
    }

    @Override
    public abstract Future<BufferedImage> getFutureTile(int var1, int var2, ImageOpObserver var3) throws ExecutionException;

    @Override
    public ImageOp getTileOp(Point point) {
        return this.getTileOp(point.x, point.y);
    }

    @Override
    public abstract ImageOp getTileOp(int var1, int var2);

    @Override
    public abstract Point[] getTileIndices(Rectangle var1);
}

