/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent.listener;

import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiEventListenerSupport
implements MultiEventListenerSupport {
    protected final ConcurrentMap<Class<?>, List<EventListener<?>>> listeners = new ConcurrentHashMap();
    protected final Object src;

    public DefaultMultiEventListenerSupport(Object object) {
        this.src = object;
    }

    @Override
    public <T> void addEventListener(Class<T> clazz, EventListener<? super T> eventListener) {
        this.listeners.putIfAbsent(clazz, new CopyOnWriteArrayList());
        for (Map.Entry entry : this.listeners.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            ((List)entry.getValue()).add(eventListener);
        }
    }

    @Override
    public <T> void removeEventListener(Class<T> clazz, EventListener<? super T> eventListener) {
        for (Map.Entry entry : this.listeners.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            ((List)entry.getValue()).remove(eventListener);
        }
    }

    @Override
    public boolean hasEventListeners(Class<?> clazz) {
        for (Map.Entry entry : this.listeners.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (!clazz2.isAssignableFrom(clazz) || ((List)entry.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<EventListener<? super T>> getEventListeners(Class<T> clazz) {
        ArrayList<EventListener<T>> arrayList = new ArrayList<EventListener<T>>();
        for (Map.Entry entry : this.listeners.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            arrayList.addAll((List)entry.getValue());
        }
        return arrayList;
    }

    @Override
    public void notify(Object object) {
        Class<?> clazz = object.getClass();
        List<EventListener<?>> list = (List<EventListener<?>>)this.listeners.get(clazz);
        if (list == null) {
            list = this.registerType(clazz);
        }
        for (EventListener eventListener : list) {
            eventListener.receive(this.src, clazz.cast(object));
        }
    }

    protected List<EventListener<?>> registerType(Class<?> clazz) {
        this.listeners.putIfAbsent(clazz, new CopyOnWriteArrayList());
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : this.listeners.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        List list = (List)this.listeners.get(clazz);
        list.addAll(hashSet);
        return list;
    }
}

