/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class BasicChatControlsInitializer
implements ChatControlsInitializer {
    private Action connectAction;
    private Action disconnectAction;
    private ChatServerConnection client;
    private JButton connectButton;
    private JButton disconnectButton;
    private PropertyChangeListener connectionListener;

    public BasicChatControlsInitializer(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
    }

    public void initializeControls(final ChatServerControls chatServerControls) {
        JToolBar jToolBar = chatServerControls.getToolbar();
        this.connectAction = new AbstractAction(Resources.getString("Chat.connect")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BasicChatControlsInitializer.this.client.setConnected(true);
            }
        };
        URL uRL = this.getClass().getResource("/images/connect.gif");
        if (uRL != null) {
            this.connectAction.putValue("ShortDescription", this.connectAction.getValue("Name"));
            this.connectAction.putValue("Name", "");
            this.connectAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.connectAction.setEnabled(true);
        this.disconnectAction = new AbstractAction(Resources.getString("Chat.disconnect")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BasicChatControlsInitializer.this.client.setConnected(false);
            }
        };
        uRL = this.getClass().getResource("/images/disconnect.gif");
        if (uRL != null) {
            this.disconnectAction.putValue("ShortDescription", this.disconnectAction.getValue("Name"));
            this.disconnectAction.putValue("Name", "");
            this.disconnectAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.disconnectAction.setEnabled(false);
        this.connectButton = jToolBar.add(this.connectAction);
        this.disconnectButton = jToolBar.add(this.disconnectAction);
        this.connectionListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                        BasicChatControlsInitializer.this.connectAction.setEnabled(!bl);
                        BasicChatControlsInitializer.this.disconnectAction.setEnabled(bl);
                        if (!bl) {
                            chatServerControls.getRoomTree().setRooms(new Room[0]);
                            chatServerControls.getCurrentRoom().setRooms(new Room[0]);
                        }
                    }
                });
            }
        };
        this.client.addPropertyChangeListener("Connected", this.connectionListener);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().remove(this.connectButton);
        chatServerControls.getToolbar().remove(this.disconnectButton);
    }
}

