/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.ServerNode;
import VASSAL.chat.node.StatusReporter;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class AsynchronousServerNode
extends ServerNode {
    private static Logger logger = Logger.getLogger(AsynchronousServerNode.class.getName());
    private StatusReporter statusReporter;
    private ReportContentsThread contentsReporter;

    public AsynchronousServerNode(String string) {
        this.init(string);
    }

    protected void init(String string) {
        this.statusReporter = new StatusReporter(string == null ? null : new HttpRequestWrapper(string), this);
        this.contentsReporter = new ReportContentsThread(this);
    }

    protected synchronized void sendContents(Node node) {
        this.contentsReporter.markChanged(node);
    }

    public static class ReportContentsThread
    extends Thread {
        private AsynchronousServerNode server;
        private Set<Node> changed;
        private long lastGlobalUpdate;
        private static final long GLOBAL_UPDATE_INTERVAL = 120000L;

        public ReportContentsThread(AsynchronousServerNode asynchronousServerNode) {
            this.server = asynchronousServerNode;
            this.changed = new HashSet<Node>();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ReportContentsThread reportContentsThread = this;
                        synchronized (reportContentsThread) {
                            this.wait();
                            this.sendContents();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private synchronized void sendContents() {
            Iterator<Node> iterator;
            this.server.statusReporter.updateContents(this.server.getLeafDescendants());
            long l = System.currentTimeMillis();
            if (l - this.lastGlobalUpdate < 120000L) {
                iterator = Arrays.asList(this.server.getChildren()).iterator();
                this.lastGlobalUpdate = l;
            } else {
                iterator = this.changed.iterator();
            }
            while (iterator.hasNext()) {
                Object object;
                Node node = iterator.next();
                logger.fine("Sending contents of " + node.getId());
                Node[] nodeArray = node.getLeafDescendants();
                Node[] nodeArray2 = node.getChildren();
                for (int i = 1; i < nodeArray2.length; ++i) {
                    object = nodeArray2[i].getChildren();
                    if (((Node[])object).length <= 0) continue;
                    try {
                        Properties properties = new PropertiesEncoder(nodeArray2[i].getInfo()).getProperties();
                        String string = properties.getProperty("owner");
                        String string2 = new PropertiesEncoder(object[0].getInfo()).getProperties().getProperty("id");
                        if (string != null && string.equals(string2)) continue;
                        properties.setProperty("owner", string2);
                        nodeArray2[i].setInfo(new PropertiesEncoder(properties).toString());
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                String string = Protocol.encodeListCommand(nodeArray);
                logger.finer(string);
                node.send(string);
                object = Protocol.encodeRoomsInfo(nodeArray2);
                node.send((String)object);
            }
            this.changed.clear();
        }

        public synchronized void markChanged(Node node) {
            logger.fine(node + " has changed");
            this.changed.add(node);
            this.notifyAll();
        }
    }
}

