/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import java.util.HashMap;
import java.util.Map;

public interface ServerStatus {
    public ModuleSummary[] getStatus();

    public String[] getSupportedTimeRanges();

    public ModuleSummary[] getHistory(String var1);

    public static class ModuleSummary {
        private String moduleName;
        private Map<String, Room> rooms = new HashMap<String, Room>();

        public ModuleSummary(String string) {
            this.moduleName = string;
        }

        public ModuleSummary(String string, Room[] roomArray) {
            this(string);
            for (Room room : roomArray) {
                this.rooms.put(room.getName(), room);
            }
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String string) {
            this.moduleName = string;
        }

        public void addRoom(Room room) {
            this.rooms.put(room.getName(), room);
        }

        public SimpleRoom getRoom(String string) {
            return (SimpleRoom)this.rooms.get(string);
        }

        public Room[] getRooms() {
            return this.rooms.values().toArray(new Room[this.rooms.size()]);
        }

        public int numPlayers() {
            Room[] roomArray = this.getRooms();
            int n = 0;
            for (int i = 0; i < roomArray.length; ++i) {
                n += ((SimpleRoom)roomArray[i]).numPlayers();
            }
            return n;
        }

        public String toString() {
            return this.moduleName;
        }
    }
}

