/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelWidget
extends Widget {
    private JPanel panel;
    private List<Widget> widgets = new ArrayList<Widget>();
    private int nColumns = 3;
    private boolean vertical = false;
    private boolean fixed = false;
    public static final String FIXED = "fixed";
    public static final String COLS = "nColumns";
    public static final String VERTICAL = "vert";

    public static String getConfigureTypeName() {
        return "Panel";
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.panel = new JPanel();
            this.panel.setLayout(this.getLayout(this.panel));
            for (Widget widget : this.widgets) {
                Component component = widget.getComponent();
                if (component instanceof JComponent) {
                    ((JComponent)component).setAlignmentX(0.0f);
                    ((JComponent)component).setAlignmentY(0.0f);
                }
                if (widget instanceof PieceSlot) {
                    this.panel.setBackground(Color.WHITE);
                }
                this.panel.add(component);
            }
        }
        return this.panel;
    }

    private LayoutManager getLayout(Container container) {
        if (this.fixed) {
            return new GridLayout(0, this.nColumns);
        }
        return new BoxLayout(container, this.vertical ? 1 : 0);
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            this.widgets.add(widget);
            if (this.panel != null) {
                Component component = widget.getComponent();
                if (component instanceof JComponent) {
                    ((JComponent)component).setAlignmentX(0.0f);
                    ((JComponent)component).setAlignmentY(0.0f);
                }
                this.panel.add(component);
                this.panel.revalidate();
            }
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            if (this.panel != null) {
                this.panel.remove(widget.getComponent());
            }
            this.widgets.remove(widget);
        }
        super.remove(buildable);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", FIXED, COLS, VERTICAL};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Fixed cell size?", "Number of columns:  ", "Vertical layout?"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Integer.class, Boolean.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLS.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return PanelWidget.this.fixed;
                }
            };
            return visibilityCondition;
        }
        if (VERTICAL.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !PanelWidget.this.fixed;
                }
            };
            return visibilityCondition;
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        } else if (FIXED.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.fixed = (Boolean)object;
        } else if (COLS.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.nColumns = (Integer)object;
            if (this.nColumns < 1) {
                ErrorDialog.dataError(new BadDataReport("Panel has < 1 column:", this.getConfigureName()));
                this.nColumns = 1;
            }
        } else if (VERTICAL.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.vertical = (Boolean)object;
        }
        if (this.panel != null) {
            this.panel.setLayout(this.getLayout(this.panel));
            this.panel.revalidate();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        if (FIXED.equals(string)) {
            return String.valueOf(this.fixed);
        }
        if (COLS.equals(string)) {
            return String.valueOf(this.nColumns);
        }
        if (VERTICAL.equals(string)) {
            return String.valueOf(this.vertical);
        }
        return null;
    }
}

