/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalMap
implements AutoConfigurable,
GameComponent,
Drawable {
    private static final long serialVersionUID = 2L;
    protected Map map;
    protected double scale = 0.19444444;
    protected Color rectColor = Color.black;
    protected final LaunchButton launch;
    protected CounterDetailViewer mouseOverViewer;
    protected final ScrollPane scroll;
    protected final View view = new View();
    protected ComponentI18nData myI18nData;
    protected static final String SCALE = "scale";
    protected static final String COLOR = "color";
    protected static final String HOTKEY = "hotkey";
    protected static final String ICON_NAME = "icon";
    protected static final String TOOLTIP = "tooltip";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String DEFAULT_ICON = "/images/overview.gif";

    public GlobalMap() {
        this.view.addMouseListener(this.view);
        this.scroll = new GlobalMapScrollPane(this.view);
        this.scroll.setBorder(BorderFactory.createEtchedBorder(0));
        this.scroll.setAlignmentX(0.0f);
        this.scroll.setAlignmentY(0.0f);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalMap.this.scroll.setVisible(!GlobalMap.this.scroll.isVisible());
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Show/Hide overview window");
        this.launch.setAttribute(HOTKEY, NamedKeyStroke.getNamedKeyStroke(79, 3));
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.mouseOverViewer = new CounterViewer();
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.view, 0));
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        if (buildable instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)buildable);
        }
        this.map.getLayeredPane().add((Component)this.scroll, JLayeredPane.PALETTE_LAYER);
    }

    @Override
    public void add(Buildable buildable) {
    }

    @Override
    public void remove(Buildable buildable) {
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.map.getLayeredPane().remove(this.scroll);
    }

    @Override
    public void build(Element element) {
        AutoConfigurable.Util.buildAttributes(element, this);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON_NAME, HOTKEY, SCALE, COLOR};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (SCALE.equals(string)) {
            if (object instanceof String) {
                object = Double.valueOf((String)object);
            }
            this.scale = (Double)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rectColor = (Color)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (SCALE.equals(string)) {
            return String.valueOf(this.scale);
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.rectColor);
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.GlobalMap.show_hide"), Resources.getString("Editor.GlobalMap.scale_factor"), Resources.getString("Editor.GlobalMap.hilight")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class, Double.class, Color.class};
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        this.view.repaint();
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    public Point componentCoordinates(Point point) {
        return new Point((int)((double)(point.x - this.map.getEdgeBuffer().width) * this.scale), (int)((double)(point.y - this.map.getEdgeBuffer().height) * this.scale));
    }

    public Point mapCoordinates(Point point) {
        return new Point((int)Math.round((double)point.x / this.scale) + this.map.getEdgeBuffer().width, (int)Math.round((double)point.y / this.scale) + this.map.getEdgeBuffer().height);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            this.scroll.setMaximumSize(this.scroll.getPreferredSize());
        } else {
            this.scroll.setVisible(false);
        }
        if (bl && !this.map.getComponentsOf(CounterDetailViewer.class).isEmpty()) {
            this.view.addMouseListener(this.mouseOverViewer);
            this.view.addMouseMotionListener(this.mouseOverViewer);
            this.scroll.addKeyListener(this.mouseOverViewer);
        } else {
            this.view.removeMouseListener(this.mouseOverViewer);
            this.view.removeMouseMotionListener(this.mouseOverViewer);
            this.scroll.removeKeyListener(this.mouseOverViewer);
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalMap.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "OverviewWindow");
    }

    @Override
    public Element getBuildElement(Document document) {
        return AutoConfigurable.Util.getBuildElement(document, this);
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "GlobalMap");
        }
        return this.myI18nData;
    }

    protected class View
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        protected View() {
        }

        protected void paintComponent(Graphics graphics) {
            GlobalMap.this.map.drawBoards(graphics, -Math.round((float)GlobalMap.this.scale * (float)GlobalMap.this.map.getEdgeBuffer().width), -Math.round((float)GlobalMap.this.scale * (float)GlobalMap.this.map.getEdgeBuffer().height), GlobalMap.this.scale, this);
            for (GamePiece gamePiece : GlobalMap.this.map.getPieces()) {
                Point point = GlobalMap.this.componentCoordinates(gamePiece.getPosition());
                gamePiece.draw(graphics, point.x, point.y, this, GlobalMap.this.scale);
            }
            GlobalMap.this.mouseOverViewer.draw(graphics, GlobalMap.this.map);
            graphics.setColor(GlobalMap.this.rectColor);
            Rectangle rectangle = GlobalMap.this.map.getView().getVisibleRect();
            Point point = GlobalMap.this.componentCoordinates(GlobalMap.this.map.mapCoordinates(rectangle.getLocation()));
            int n = (int)(GlobalMap.this.scale * (double)rectangle.width / GlobalMap.this.map.getZoom());
            int n2 = (int)(GlobalMap.this.scale * (double)rectangle.height / GlobalMap.this.map.getZoom());
            graphics.drawRect(point.x, point.y, n, n2);
            graphics.drawRect(point.x - 1, point.y - 1, n + 2, n2 + 2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            GlobalMap.this.map.centerAt(GlobalMap.this.mapCoordinates(mouseEvent.getPoint()));
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)((double)(GlobalMap.this.map.mapSize().width - 2 * GlobalMap.this.map.getEdgeBuffer().width) * GlobalMap.this.scale), (int)((double)(GlobalMap.this.map.mapSize().height - 2 * GlobalMap.this.map.getEdgeBuffer().height) * GlobalMap.this.scale));
        }
    }

    protected class GlobalMapScrollPane
    extends ScrollPane {
        private static final long serialVersionUID = 1L;

        public GlobalMapScrollPane(Component component) {
            super(component, 20, 30);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = GlobalMap.this.view.getPreferredSize();
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public Dimension getMaximumSize() {
            Dimension dimension = this.getPreferredSize();
            if (this.verticalScrollBar.isVisible()) {
                dimension.width += this.verticalScrollBar.getPreferredSize().width;
            }
            if (this.horizontalScrollBar.isVisible()) {
                dimension.height += this.horizontalScrollBar.getPreferredSize().height;
            }
            return dimension;
        }

        public void setBounds(Rectangle rectangle) {
            Dimension dimension = GlobalMap.this.map.getView().getParent().getSize();
            Dimension dimension2 = GlobalMap.this.view.getPreferredSize();
            Insets insets = this.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            boolean bl = dimension.width < dimension2.width;
            boolean bl2 = dimension.height < dimension2.height;
            Dimension dimension3 = new Dimension();
            dimension3.width = dimension.width < dimension2.width ? dimension.width : (bl2 ? Math.min(dimension.width, dimension2.width + this.verticalScrollBar.getPreferredSize().width) : dimension2.width);
            dimension3.height = dimension.height < dimension2.height ? dimension.height : (bl ? Math.min(dimension.height, dimension2.height + this.horizontalScrollBar.getPreferredSize().height) : dimension2.height);
            super.setBounds(0, 0, dimension3.width, dimension3.height);
        }

        public void setVisible(boolean bl) {
            LayoutManager layoutManager;
            super.setVisible(bl);
            if (bl && (layoutManager = this.getParent().getLayout()) instanceof Map.InsetLayout) {
                layoutManager.layoutContainer(this.getParent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CounterViewer
    extends CounterDetailViewer {
        public CounterViewer() {
            this.map = GlobalMap.this.map;
            this.view = GlobalMap.this.view;
        }

        @Override
        protected List<GamePiece> getDisplayablePieces() {
            Point point = this.currentMousePosition.getPoint();
            Point point2 = GlobalMap.this.map.componentCoordinates(GlobalMap.this.mapCoordinates(point));
            this.currentMousePosition.translatePoint(point2.x - point.x, point2.y - point.y);
            List<GamePiece> list = super.getDisplayablePieces();
            this.currentMousePosition.translatePoint(point.x - point2.x, point.y - point2.y);
            return list;
        }

        @Override
        protected double getZoom() {
            return GlobalMap.this.scale;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, GlobalMap.DEFAULT_ICON);
        }
    }
}

