/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.migrator.ConversionException;
import org.slf4j.migrator.FileSelector;
import org.slf4j.migrator.InplaceFileConverter;
import org.slf4j.migrator.RuleSetFactory;
import org.slf4j.migrator.internal.MigratorFrame;
import org.slf4j.migrator.internal.ProgressListener;
import org.slf4j.migrator.line.RuleSet;

public class ProjectConverter {
    private RuleSet ruleSet;
    private List<ConversionException> exception;
    ProgressListener progressListener;

    public static void main(String[] stringArray) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MigratorFrame migratorFrame = new MigratorFrame();
                migratorFrame.setLocationRelativeTo(null);
                migratorFrame.setVisible(true);
            }
        });
    }

    public ProjectConverter(int n, ProgressListener progressListener) {
        this.progressListener = progressListener;
        this.ruleSet = RuleSetFactory.getMatcherImpl(n);
        if (this.ruleSet == null) {
            this.addException(new ConversionException("Conversion mode not implemented yet"));
        }
    }

    public void convertProject(File file) {
        FileSelector fileSelector = new FileSelector(this.progressListener);
        List<File> list = fileSelector.selectJavaFilesInFolder(file);
        this.scanFileList(list);
        this.progressListener.onDone();
    }

    private void scanFileList(List<File> list) {
        this.progressListener.onFileScanBegin();
        for (File file : list) {
            this.progressListener.onFileScan(file);
            this.scanFile(file);
        }
    }

    private void scanFile(File file) {
        try {
            InplaceFileConverter inplaceFileConverter = new InplaceFileConverter(this.ruleSet, this.progressListener);
            inplaceFileConverter.convert(file);
        }
        catch (IOException iOException) {
            this.addException(new ConversionException(iOException.toString()));
        }
    }

    public void addException(ConversionException conversionException) {
        if (this.exception == null) {
            this.exception = new ArrayList<ConversionException>();
        }
        this.exception.add(conversionException);
    }

    public void printException() {
        if (this.exception != null) {
            for (ConversionException conversionException : this.exception) {
                conversionException.print();
            }
            this.exception = null;
        }
    }
}

