/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;
import javax.xml.transform.TransformerException;

final class TinyNamespaceImpl
extends TinyNodeImpl {
    private int parentNode;
    private int nameCode;

    public TinyNamespaceImpl(TinyDocumentImpl tinyDocumentImpl, int n) {
        this.document = tinyDocumentImpl;
        this.nodeNr = n;
        this.nameCode = this.document.getNamePool().allocate("", "", this.getLocalName());
    }

    public int getNamespaceCode() {
        return this.document.namespaceCode[this.nodeNr];
    }

    @Override
    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    void setParentNode(int n) {
        this.parentNode = n;
    }

    @Override
    public int getNameCode() {
        return this.nameCode;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getLocalName();
    }

    @Override
    public String getLocalName() {
        return this.document.getNamePool().getPrefixFromNamespaceCode(this.document.namespaceCode[this.nodeNr]);
    }

    @Override
    public String getURI() {
        return null;
    }

    @Override
    public NodeInfo getParent() {
        return this.document.getNode(this.parentNode);
    }

    @Override
    public final boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof TinyNamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        TinyNamespaceImpl tinyNamespaceImpl = (TinyNamespaceImpl)nodeInfo;
        return this.parentNode == ((TinyNamespaceImpl)nodeInfo).parentNode && this.document == tinyNamespaceImpl.document && this.nodeNr == ((TinyNamespaceImpl)nodeInfo).nodeNr;
    }

    @Override
    public final short getNodeType() {
        return 13;
    }

    @Override
    public final String getStringValue() {
        return this.document.getNamePool().getURIFromNamespaceCode(this.document.namespaceCode[this.nodeNr]);
    }

    @Override
    public String generateId() {
        return this.getParent().generateId() + "_xmlns_" + this.getFingerprint();
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        outputter.copyNamespaceNode(this.getNamespaceCode());
    }

    @Override
    protected long getSequenceNumber() {
        return ((TinyNodeImpl)this.getParent()).getSequenceNumber() + (long)this.nodeNr + 1L;
    }
}

