/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import java.text.DecimalFormatSymbols;
import javax.xml.transform.TransformerConfigurationException;

public class XSLDecimalFormat
extends StyleElement {
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.NAME) {
                this.name = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.DECIMAL_SEPARATOR) {
                this.decimalSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.GROUPING_SEPARATOR) {
                this.groupingSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.INFINITY) {
                this.infinity = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.MINUS_SIGN) {
                this.minusSign = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.NAN) {
                this.NaN = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.PERCENT) {
                this.percent = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.PER_MILLE) {
                this.perMille = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.ZERO_DIGIT) {
                this.zeroDigit = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.DIGIT) {
                this.digit = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.PATTERN_SEPARATOR) {
                this.patternSeparator = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        if (this.decimalSeparator != null) {
            decimalFormatSymbols.setDecimalSeparator(this.toChar(this.decimalSeparator));
        }
        if (this.groupingSeparator != null) {
            decimalFormatSymbols.setGroupingSeparator(this.toChar(this.groupingSeparator));
        }
        if (this.infinity != null) {
            decimalFormatSymbols.setInfinity(this.infinity);
        }
        if (this.minusSign != null) {
            decimalFormatSymbols.setMinusSign(this.toChar(this.minusSign));
        }
        if (this.NaN != null) {
            decimalFormatSymbols.setNaN(this.NaN);
        }
        if (this.percent != null) {
            decimalFormatSymbols.setPercent(this.toChar(this.percent));
        }
        if (this.perMille != null) {
            decimalFormatSymbols.setPerMill(this.toChar(this.perMille));
        }
        if (this.zeroDigit != null) {
            decimalFormatSymbols.setZeroDigit(this.toChar(this.zeroDigit));
        }
        if (this.digit != null) {
            decimalFormatSymbols.setDigit(this.toChar(this.digit));
        }
        if (this.patternSeparator != null) {
            decimalFormatSymbols.setPatternSeparator(this.toChar(this.patternSeparator));
        }
        DecimalFormatManager decimalFormatManager = this.getPrincipalStyleSheet().getDecimalFormatManager();
        if (this.name == null) {
            decimalFormatManager.setDefaultDecimalFormat(decimalFormatSymbols);
        } else {
            int n;
            if (!Name.isQName(this.name)) {
                this.compileError("Name of decimal-format must be a valid QName");
            }
            try {
                n = this.makeNameCode(this.name, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
                return;
            }
            decimalFormatManager.setNamedDecimalFormat(n, decimalFormatSymbols);
        }
    }

    @Override
    public void process(Context context) {
    }

    private char toChar(String string) throws TransformerConfigurationException {
        if (string.length() != 1) {
            this.compileError("Attribute \"" + string + "\" should be a single character");
        }
        return string.charAt(0);
    }
}

