/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class BooleanFn
extends Function {
    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0].getDataType() == 1) {
            return this.argument[0];
        }
        if (this.argument[0] instanceof Value) {
            return new BooleanValue(((Value)this.argument[0]).asBoolean());
        }
        return this;
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        return this.argument[0].evaluateAsBoolean(context);
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        BooleanFn booleanFn = new BooleanFn();
        booleanFn.addArgument(this.argument[0].reduce(n, context));
        booleanFn.setStaticContext(this.getStaticContext());
        return booleanFn.simplify();
    }
}

