#!/bin/bash

# BEGIN installer-specific params
readonly REDMINE_PROJECT_ID=8
readonly ISSUE_TITLE="[IMSTALL-MEDIA]: report-bug.sh uploaded install.log"
readonly ISSUE_DESC=""
readonly UPLOAD_FILENAME="install.log"
readonly UPLOAD_MIMETYPE='text/plain'
readonly UPLOAD_DESC="$(grep 'VERSION_ID=' /etc/os-release) $(grep 'VARIANT_ID=' /etc/os-release)"
readonly UPLOAD_FILE=/home/parabola/Desktop/install.log
# TODO: generalize this script to handle image uploads and user-selected tracker and description
# readonly REDMINE_PROJECT_ID=$1
# readonly ISSUE_TITLE="$2"
# readonly UPLOAD_FILENAME="$3"
# readonly UPLOAD_MIMETYPE="$4"
# readonly UPLOAD_DESC="$5"
# readonly UPLOAD_FILE="$6"
# END installer-specific params


readonly REDMINE_URL=https://labs.parabola.nu
readonly REDMINE_API_KEY='978ee27e1b21969eeeae83a1760b7467b63d32bf'
readonly POST_UPLOADS_URL=$REDMINE_URL/uploads.xml
readonly POST_ISSUES_URL=$REDMINE_URL/issues.xml
readonly POST_UPLOADS_MIMETYPE='application/octet-stream'
readonly POST_ISSUES_MIMETYPE='application/xml'
readonly POST_ISSUE_XML_FMT="
<issue>
  <project_id>%s</project_id>
  <subject>%s</subject>
  <description>%s</description>%s
</issue>
"
readonly UPLOADS_XML_FMT="
  <uploads type=\"array\">%s
  </uploads>
"
readonly UPLOAD_XML_FMT="
    <upload>
      <token>%s</token>
      <filename>%s</filename>
      <description>%s</description>
      <content_type>%s</content_type>
    </upload>
"


: <<EXAMPLE_UPLOAD_RESPONSE
<?xml version="1.0" encoding="UTF-8"?>
<upload>
  <token>338.261c95326446ce36879671466457f2db</token>
</upload>
EXAMPLE_UPLOAD_RESPONSE

: <<EXAMPLE_CREATE_ISSUE_RESPONSE
<?xml version="1.0" encoding="UTF-8"?>
<issue>
  <id>1576</id>
  <project id="8" name="Installation media"/>
  <tracker id="1" name="Bug"/>
  <status id="1" name="open"/>
  <priority id="3" name="bug"/>
  <author id="944" name="parabola-user"/>
  <subject>Creating an issue with a uploaded file via curl</subject>
  <description>details here ...</description>
  <start_date>2017-12-17</start_date>
  <due_date/>
  <done_ratio>0</done_ratio>
  <is_private>false</is_private>
  <estimated_hours/>
  <total_estimated_hours/>
  <created_on>2017-12-17T16:07:38Z</created_on>
  <updated_on>2017-12-17T16:07:38Z</updated_on>
  <closed_on/>
</issue>
EXAMPLE_CREATE_ISSUE_RESPONSE


PostRequest()
{
  mimetype=$1
  body=$2
  url=$3

  curl -X POST                                        \
       --header "Content-Type: $mimetype"             \
       --header "X-Redmine-API-Key: $REDMINE_API_KEY" \
       --data-binary "$body"                          \
       $url
}


if [ "$UPLOAD_FILE" ]
then resp=$(PostRequest $POST_UPLOADS_MIMETYPE "@$UPLOAD_FILE" $POST_UPLOADS_URL)
     upload_token=$(echo "$resp" | sed 's|.*<token>\(.*\)</token>.*|\1|'
     [ -z "$upload_token" ] && echo "upload failed" && exit 1

     upload_xml=$(printf "$UPLOAD_XML_FMT" "$upload_token" "$UPLOAD_FILENAME" \
                                           "$UPLOAD_DESC" $UPLOAD_MIMETYPE    )
     uploads_xml=$(printf "$UPLOADS_XML_FMT" "$upload_xml")
fi
issue_xml=$(printf "$POST_ISSUE_XML_FMT" $REDMINE_PROJECT_ID "$ISSUE_TITLE" \
                                         "$ISSUE_DESC" "$uploads_xml"       )
resp=$(PostRequest $POST_ISSUES_MIMETYPE "$issue_xml" $POST_ISSUES_URL)
echo "$(echo "$resp" | sed 's|.*<id>\(.*\)</id>.*|\1|')"
