/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public final class Acl {
    public static final int GET = 1;
    public static final int ADD = 2;
    public static final int REPLACE = 4;
    public static final int DELETE = 8;
    public static final int EXEC = 16;
    public static final int ALL_PERMISSION = 31;
    private static final int[] PERMISSION_CODES = new int[]{2, 8, 16, 1, 4};
    private static final String[] PERMISSION_NAMES = new String[]{"Add", "Delete", "Exec", "Get", "Replace"};
    private static final String ALL_PRINCIPALS = "*";
    private final TreeMap principalPermissions;
    private final int globalPermissions;

    public Acl(String string) {
        if (string == null || string.equals("")) {
            this.principalPermissions = new TreeMap();
            this.globalPermissions = 0;
            return;
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        int n = 0;
        String[] stringArray = Acl.split(string, '&', -1);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                throw new IllegalArgumentException("Invalid ACL string: empty ACL entry.");
            }
            String[] stringArray2 = Acl.split(stringArray[i], '=', 2);
            if (stringArray2.length == 1) {
                throw new IllegalArgumentException("Invalid ACL string: no '=' in ACL entry.");
            }
            if (stringArray2[1].length() == 0) {
                throw new IllegalArgumentException("Invalid ACL string: no server identifiers in ACL entry.");
            }
            int n2 = Acl.parseCommand(stringArray2[0]);
            String[] stringArray3 = Acl.split(stringArray2[1], '+', -1);
            for (int j = 0; j < stringArray3.length; ++j) {
                if (stringArray3[j].length() == 0) {
                    throw new IllegalArgumentException("Invalid ACL string: empty server identifier.");
                }
                if (stringArray3[j].equals(ALL_PRINCIPALS)) {
                    n |= n2;
                    continue;
                }
                Acl.checkServerId(stringArray3[j], "Invalid ACL string: server ID contains illegal character");
                Integer n3 = (Integer)treeMap.get(stringArray3[j]);
                int n4 = n3 != null ? n3 : 0;
                treeMap.put(stringArray3[j], new Integer(n4 | n2));
            }
        }
        this.principalPermissions = treeMap;
        this.globalPermissions = n;
    }

    public Acl(String[] stringArray, int[] nArray) {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("The lengths of the principal and permission arrays are not the same.");
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ALL_PRINCIPALS.equals(stringArray[i])) {
                Acl.checkPrincipal(stringArray[i]);
            }
            Acl.checkPermissions(nArray[i]);
            Integer n2 = new Integer(nArray[i]);
            Integer n3 = treeMap.put(stringArray[i], n2);
            if (n3 == null) continue;
            throw new IllegalArgumentException("Principal '" + stringArray[i] + "' appears multiple times in the principal array.");
        }
        Object v = treeMap.remove(ALL_PRINCIPALS);
        if (v != null) {
            n = (Integer)v;
        }
        this.principalPermissions = treeMap;
        this.globalPermissions = n;
    }

    private Acl(Acl acl, String string, int n) {
        TreeMap treeMap = (TreeMap)acl.principalPermissions.clone();
        int n2 = acl.globalPermissions;
        int n3 = n2 & ~n;
        if (ALL_PRINCIPALS.equals(string)) {
            Acl.deleteFromAll(treeMap, n3);
            n2 = n;
        } else {
            Acl.checkPrincipal(string);
            if (n3 != 0) {
                throw new IllegalArgumentException("Cannot revoke globally set permissions (" + Acl.writeCommands(n3) + ") from a specific principal (" + string + ").");
            }
            Acl.setPrincipalPermission(treeMap, string, n);
        }
        this.principalPermissions = treeMap;
        this.globalPermissions = n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Acl)) {
            return false;
        }
        Acl acl = (Acl)object;
        if (this.globalPermissions != acl.globalPermissions || this.principalPermissions.size() != acl.principalPermissions.size()) {
            return false;
        }
        return this.toString().equals(acl.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public synchronized Acl addPermission(String string, int n) {
        Acl.checkPermissions(n);
        int n2 = this.getPermissions(string);
        return this.setPermission(string, n2 | n);
    }

    public synchronized Acl deletePermission(String string, int n) {
        Acl.checkPermissions(n);
        int n2 = this.getPermissions(string);
        return this.setPermission(string, n2 & ~n);
    }

    public synchronized int getPermissions(String string) {
        int n = 0;
        if (!ALL_PRINCIPALS.equals(string)) {
            Acl.checkPrincipal(string);
            Object v = this.principalPermissions.get(string);
            if (v != null) {
                n = (Integer)v;
            }
        }
        return n | this.globalPermissions;
    }

    public synchronized boolean isPermitted(String string, int n) {
        Acl.checkPermissions(n);
        int n2 = this.getPermissions(string);
        return (n & n2) == n;
    }

    public synchronized Acl setPermission(String string, int n) {
        Acl.checkPermissions(n);
        Acl acl = new Acl(this, string, n);
        return acl;
    }

    public String[] getPrincipals() {
        return this.principalPermissions.keySet().toArray(new String[0]);
    }

    public synchronized String toString() {
        String string = null;
        for (int i = 0; i < PERMISSION_CODES.length; ++i) {
            string = this.writeEntry(PERMISSION_CODES[i], string);
        }
        return string != null ? string : "";
    }

    private String writeEntry(int n, String string) {
        String string2 = null;
        if ((n & this.globalPermissions) > 0) {
            string2 = ALL_PRINCIPALS;
        } else {
            for (Map.Entry entry : this.principalPermissions.entrySet()) {
                if ((n & (Integer)entry.getValue()) <= 0) continue;
                string2 = Acl.appendEntry(string2, '+', (String)entry.getKey());
            }
        }
        if (string2 == null) {
            return string;
        }
        return Acl.appendEntry(string, '&', Acl.writeCommands(n) + '=' + string2);
    }

    private static void deleteFromAll(TreeMap treeMap, int n) {
        for (Map.Entry entry : treeMap.entrySet()) {
            Acl.setPrincipalPermission(treeMap, (String)entry.getKey(), (Integer)entry.getValue() & ~n);
        }
    }

    private static void setPrincipalPermission(TreeMap treeMap, String string, int n) {
        if (n == 0) {
            treeMap.remove(string);
        } else {
            treeMap.put(string, new Integer(n));
        }
    }

    private static String writeCommands(int n) {
        String string = null;
        for (int i = 0; i < PERMISSION_CODES.length; ++i) {
            if ((n & PERMISSION_CODES[i]) == 0) continue;
            string = Acl.appendEntry(string, ',', PERMISSION_NAMES[i]);
        }
        return string != null ? string : "";
    }

    private static String appendEntry(String string, char c, String string2) {
        return string != null ? string + c + string2 : string2;
    }

    private static int parseCommand(String string) {
        int n = Arrays.asList(PERMISSION_NAMES).indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid ACL string: unknown command '" + string + "'.");
        }
        return PERMISSION_CODES[n];
    }

    private static void checkPermissions(int n) {
        if ((n & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("Invalid ACL permission value: " + n);
        }
    }

    private static void checkPrincipal(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Principal is null or empty.");
        }
        Acl.checkServerId(string, "Principal name contains illegal character");
    }

    private static void checkServerId(String string, String string2) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("*=+&".indexOf(cArray[i]) == -1 && !Character.isWhitespace(cArray[i])) continue;
            throw new IllegalArgumentException(string2 + " '" + cArray[i] + "'.");
        }
    }

    private static String[] split(String string, char c, int n) {
        int n2;
        int n3;
        Vector<String> vector = new Vector<String>();
        boolean bl = n > 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (n2 != c) {
                stringBuffer.append((char)n2);
                continue;
            }
            ++n4;
            vector.add(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            if (!bl || n4 != n - 1) continue;
            break;
        }
        while (n3 < string.length()) {
            n2 = string.charAt(n3);
            stringBuffer.append((char)n2);
            ++n3;
        }
        vector.add(stringBuffer.toString());
        n2 = vector.size();
        if (0 == n) {
            String string2;
            for (int i = vector.size() - 1; i >= 0 && "".equals(string2 = (String)vector.elementAt(i)); --i) {
                --n2;
            }
        }
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

