/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.coordinator.CoordinationPermissionCollection;
import org.osgi.service.coordinator.SignerProperty;

public final class CoordinationPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    public static final String INITIATE = "initiate";
    public static final String PARTICIPATE = "participate";
    public static final String ADMIN = "admin";
    private static final int ACTION_INITIATE = 1;
    private static final int ACTION_PARTICIPATE = 2;
    private static final int ACTION_ADMIN = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public CoordinationPermission(String string, String string2) {
        this(CoordinationPermission.parseFilter(string), CoordinationPermission.parseActions(string2));
    }

    public CoordinationPermission(String string, Bundle bundle, String string2) {
        super(string);
        this.setTransients(null, CoordinationPermission.parseActions(string2));
        this.bundle = bundle;
        if (string == null) {
            throw new NullPointerException("coordinationName must not be null");
        }
        if (bundle == null) {
            throw new NullPointerException("coordinationBundle must not be null");
        }
    }

    CoordinationPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 7) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 4 || cArray[n2 - 4] != 'a' && cArray[n2 - 4] != 'A' || cArray[n2 - 3] != 'd' && cArray[n2 - 3] != 'D' || cArray[n2 - 2] != 'm' && cArray[n2 - 2] != 'M' || cArray[n2 - 1] != 'i' && cArray[n2 - 1] != 'I' || cArray[n2] != 'n' && cArray[n2] != 'N')) {
                n3 = 5;
                n |= 4;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'i' && cArray[n2 - 7] != 'I' || cArray[n2 - 6] != 'n' && cArray[n2 - 6] != 'N' || cArray[n2 - 5] != 'i' && cArray[n2 - 5] != 'I' || cArray[n2 - 4] != 't' && cArray[n2 - 4] != 'T' || cArray[n2 - 3] != 'i' && cArray[n2 - 3] != 'I' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 8;
                n |= 1;
            } else if (!(n2 < 10 || cArray[n2 - 10] != 'p' && cArray[n2 - 10] != 'P' || cArray[n2 - 9] != 'a' && cArray[n2 - 9] != 'A' || cArray[n2 - 8] != 'r' && cArray[n2 - 8] != 'R' || cArray[n2 - 7] != 't' && cArray[n2 - 7] != 'T' || cArray[n2 - 6] != 'i' && cArray[n2 - 6] != 'I' || cArray[n2 - 5] != 'c' && cArray[n2 - 5] != 'C' || cArray[n2 - 4] != 'i' && cArray[n2 - 4] != 'I' || cArray[n2 - 3] != 'p' && cArray[n2 - 3] != 'P' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 11;
                n |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission coordinationPermission = (CoordinationPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (coordinationPermission.filter != null) {
            return false;
        }
        return this.implies0(coordinationPermission, 0);
    }

    boolean implies0(CoordinationPermission coordinationPermission, int n) {
        int n2 = coordinationPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        return filter.matches(coordinationPermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 4) == 4) {
                stringBuffer.append(ADMIN);
                bl = true;
            }
            if ((n & 1) == 1) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(INITIATE);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(PARTICIPATE);
                bl = true;
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new CoordinationPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission coordinationPermission = (CoordinationPermission)object;
        return this.action_mask == coordinationPermission.action_mask && this.getName().equals(coordinationPermission.getName()) && (this.bundle == coordinationPermission.bundle || this.bundle != null && this.bundle.equals(coordinationPermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(CoordinationPermission.parseFilter(this.getName()), CoordinationPermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("coordination.name", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(CoordinationPermission.this.bundle.getBundleId()));
                    hashMap.put("location", CoordinationPermission.this.bundle.getLocation());
                    String string = CoordinationPermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(CoordinationPermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = hashMap;
        return this.properties;
    }
}

