/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class AtLeastXNumberOfInvocationsChecker {
    Reporter reporter = new Reporter();
    InvocationsFinder finder = new InvocationsFinder();
    InvocationMarker invocationMarker = new InvocationMarker();

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, int n) {
        List<Invocation> list2 = this.finder.findInvocations(list, invocationMatcher);
        int n2 = list2.size();
        if (n > n2) {
            Location location = this.finder.getLastLocation(list2);
            this.reporter.tooLittleActualInvocations(new AtLeastDiscrepancy(n, n2), invocationMatcher, location);
        }
        this.invocationMarker.markVerified(list2, (CapturesArgumensFromInvocation)invocationMatcher);
    }
}

