/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import org.mockito.internal.debugging.FindingsListener;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.internal.util.StringJoiner;
import org.mockito.invocation.Invocation;

public class LoggingListener
implements FindingsListener {
    private final boolean warnAboutUnstubbed;
    private final MockitoLogger logger;

    public LoggingListener(boolean bl, MockitoLogger mockitoLogger) {
        this.warnAboutUnstubbed = bl;
        this.logger = mockitoLogger;
    }

    @Override
    public void foundStubCalledWithDifferentArgs(Invocation invocation, InvocationMatcher invocationMatcher) {
        this.logger.log(StringJoiner.join(" *** Stubbing warnings from Mockito: *** ", "", "stubbed with those args here   " + invocation.getLocation(), "BUT called with different args " + invocationMatcher.getInvocation().getLocation(), ""));
    }

    @Override
    public void foundUnusedStub(Invocation invocation) {
        this.logger.log("This stubbing was never used   " + invocation.getLocation() + "\n");
    }

    @Override
    public void foundUnstubbed(InvocationMatcher invocationMatcher) {
        if (this.warnAboutUnstubbed) {
            this.logger.log(StringJoiner.join("This method was not stubbed ", invocationMatcher, invocationMatcher.getInvocation().getLocation(), ""));
        }
    }

    public boolean isWarnAboutUnstubbed() {
        return this.warnAboutUnstubbed;
    }

    public MockitoLogger getLogger() {
        return this.logger;
    }
}

