/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.iterators;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListIteratorWrapper<E>
implements ListIterator<E> {
    private final Iterator<E> iterator;
    private final LinkedList<E> list = new LinkedList();
    private int currentIndex = 0;
    private int wrappedIteratorIndex = 0;
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "ListIteratorWrapper does not support optional operations of ListIterator.";

    public ListIteratorWrapper(Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterator = iterator;
    }

    @Override
    public void add(E o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex == this.wrappedIteratorIndex) {
            return this.iterator.hasNext();
        }
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentIndex != 0;
    }

    @Override
    public E next() throws NoSuchElementException {
        if (this.currentIndex < this.wrappedIteratorIndex) {
            ++this.currentIndex;
            return this.list.get(this.currentIndex - 1);
        }
        E retval = this.iterator.next();
        this.list.add(retval);
        ++this.currentIndex;
        ++this.wrappedIteratorIndex;
        return retval;
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public E previous() throws NoSuchElementException {
        if (this.currentIndex == 0) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        return this.list.get(this.currentIndex);
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void set(E o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }
}

