/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lcmc.data.AccessMode;
import lcmc.data.CRMXML;
import lcmc.data.ConfigData;
import lcmc.data.ResourceAgent;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.HbCategoryInfo;
import lcmc.gui.resources.ResourceAgentClassInfo;
import lcmc.gui.resources.ServicesInfo;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class AvailableServiceInfo
extends HbCategoryInfo {
    private final ResourceAgent resourceAgent;
    private static final ImageIcon AVAIL_SERVICES_ICON = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceStartedIconSmall"));
    private static final ImageIcon BACK_ICON = Tools.createImageIcon(Tools.getDefault("BackIcon"));

    public AvailableServiceInfo(ResourceAgent resourceAgent, Browser browser) {
        super(resourceAgent.getName(), browser);
        this.resourceAgent = resourceAgent;
    }

    ResourceAgent getResourceAgent() {
        return this.resourceAgent;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return AVAIL_SERVICES_ICON;
    }

    @Override
    protected String getInfoType() {
        return "text/html";
    }

    @Override
    public String getInfo() {
        StringBuilder s = new StringBuilder(80);
        CRMXML crmXML = this.getBrowser().getCRMXML();
        s.append("<h2>");
        s.append(this.getName());
        s.append(" (");
        s.append(crmXML.getVersion(this.resourceAgent));
        s.append(")</h2><h3>");
        s.append(crmXML.getShortDesc(this.resourceAgent));
        s.append("</h3>");
        s.append(crmXML.getLongDesc(this.resourceAgent));
        s.append("<br><br>");
        List<String> params = crmXML.getParameters(this.resourceAgent, false);
        for (String param : params) {
            if (crmXML.isMetaAttr(this.resourceAgent, param) || "ra".equals(param) || "__pckmkid".equals(param) || "__drbdmcid".equals(param)) continue;
            s.append("<b>");
            s.append(param);
            s.append("</b><br>");
            s.append(crmXML.getParamShortDesc(this.resourceAgent, param));
            s.append("<br>");
        }
        return s.toString();
    }

    @Override
    protected JComponent getBackButton() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        MyButton overviewButton = new MyButton(Tools.getString("ClusterBrowser.RAsOverviewButton"), BACK_ICON);
        overviewButton.setPreferredSize(new Dimension(Tools.getConfigData().scaled(180), Tools.getConfigData().scaled(50)));
        overviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceAgentClassInfo raci = AvailableServiceInfo.this.getBrowser().getClassInfoMap(AvailableServiceInfo.this.resourceAgent.getResourceClass());
                if (raci != null) {
                    raci.selectMyself();
                }
            }
        });
        buttonPanel.add((Component)overviewButton, "West");
        buttonPanel.add((Component)this.getActionsButton(), "East");
        return buttonPanel;
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        MyMenuItem addServiceMenu = new MyMenuItem(Tools.getString("ClusterBrowser.AddServiceToCluster"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (AvailableServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void action() {
                AvailableServiceInfo.this.hidePopup();
                ServicesInfo si = AvailableServiceInfo.this.getBrowser().getServicesInfo();
                boolean testOnly = false;
                si.addServicePanel(AvailableServiceInfo.this.resourceAgent, null, true, null, null, false);
            }
        };
        items.add(addServiceMenu);
        return items;
    }
}

