/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lcmc.Exceptions;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.data.resources.Network;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.ClusterTab;
import lcmc.gui.SSHGui;
import lcmc.utilities.Tools;

public final class Cluster {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private final Set<Host> hosts = new LinkedHashSet<Host>();
    private ClusterTab clusterTab = null;
    private ClusterBrowser clusterBrowser;
    private final Color[] hostColors = new Color[]{new Color(228, 228, 32), new Color(102, 204, 255), Color.PINK, new Color(255, 100, 0), Color.WHITE};
    private boolean savable = true;
    private final Set<Host> proxyHosts = new LinkedHashSet<Host>();

    public Cluster() {
    }

    public Cluster(String name) {
        this.name = name;
    }

    public void createClusterBrowser() {
        this.clusterBrowser = new ClusterBrowser(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterBrowser getBrowser() {
        return this.clusterBrowser;
    }

    public void removeCluster() {
        ClusterBrowser cb = this.clusterBrowser;
        if (cb != null) {
            this.clusterBrowser.stopServerStatus();
            this.clusterBrowser.stopDrbdStatus();
            this.clusterBrowser.stopClStatus();
        }
    }

    public void addHost(Host host) {
        int id = this.hosts.size();
        host.setIndex(id);
        if (id < this.hostColors.length) {
            host.setColor(this.hostColors[id]);
        }
        this.hosts.add(host);
        this.proxyHosts.add(host);
    }

    public Set<Host> getHosts() {
        return this.hosts;
    }

    public Host[] getHostsArray() {
        return this.hosts.toArray(new Host[this.hosts.size()]);
    }

    public String[] getHostNames() {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (Host host : this.hosts) {
            hostNames.add(host.getName());
        }
        return hostNames.toArray(new String[hostNames.size()]);
    }

    public void clearHosts() {
        this.hosts.clear();
    }

    public int hostsCount() {
        return this.hosts.size();
    }

    public String getName() {
        return this.name;
    }

    public void setClusterTab(ClusterTab clusterTab) {
        this.clusterTab = clusterTab;
    }

    public ClusterTab getClusterTab() {
        return this.clusterTab;
    }

    public List<String> getCommonBlockDevices() {
        List<String> blockDevicesNamesIntersection = null;
        for (Host host : this.hosts) {
            blockDevicesNamesIntersection = host.getBlockDevicesNamesIntersection(blockDevicesNamesIntersection);
        }
        ArrayList<String> commonBlockDevices = new ArrayList<String>();
        for (String i : blockDevicesNamesIntersection) {
            commonBlockDevices.add(i);
        }
        return commonBlockDevices;
    }

    public BlockDevice[] getHostBlockDevices(String device) {
        ArrayList<BlockDevice> list = new ArrayList<BlockDevice>();
        for (Host host : this.hosts) {
            BlockDevice bd = host.getBlockDevice(device);
            list.add(bd);
        }
        return list.toArray(new BlockDevice[list.size()]);
    }

    public boolean contains(String hostName) {
        for (Host host : this.hosts) {
            if (hostName == null || !hostName.equals(host.getName())) continue;
            return true;
        }
        return false;
    }

    public Network[] getCommonNetworks() {
        Map<String, String> networksIntersection = null;
        for (Host host : this.hosts) {
            networksIntersection = host.getNetworksIntersection(networksIntersection);
        }
        ArrayList<Network> commonNetworks = new ArrayList<Network>();
        for (String netIp : networksIntersection.keySet()) {
            ArrayList<String> ips = new ArrayList<String>();
            for (Host host : this.hosts) {
                ips.addAll(host.getIpsFromNetwork(netIp));
            }
            String netMask = networksIntersection.get(netIp);
            Network network = new Network(netIp, ips.toArray(new String[ips.size()]), netMask);
            commonNetworks.add(network);
        }
        return commonNetworks.toArray(new Network[commonNetworks.size()]);
    }

    public String[] getCommonFileSystems() {
        Set<String> intersection = null;
        for (Host host : this.hosts) {
            intersection = Tools.getIntersection(host.getFileSystemsList(), intersection);
        }
        return intersection.toArray(new String[intersection.size()]);
    }

    public String[] getCommonMountPoints() {
        Set<String> intersection = null;
        for (Host host : this.hosts) {
            intersection = Tools.getIntersection(host.getMountPointsList(), intersection);
        }
        return intersection.toArray(new String[intersection.size()]);
    }

    public List<Color> getHostColors(List<String> nodes) {
        ArrayList<Color> colors = new ArrayList<Color>();
        if (nodes == null || nodes.isEmpty()) {
            colors.add(Tools.getDefaultColor("CRMGraph.FillPaintStopped"));
            return colors;
        }
        for (String node : nodes) {
            for (Host host : this.hosts) {
                if (!node.equalsIgnoreCase(host.getName())) continue;
                colors.add(host.getPmColors()[0]);
            }
        }
        if (colors.isEmpty()) {
            colors.add(Color.WHITE);
        }
        return colors;
    }

    public Host getHostByName(String name) {
        for (Host host : this.hosts) {
            if (!name.equals(host.getName())) continue;
            return host;
        }
        return null;
    }

    public boolean connect(Window rootPane, boolean progressIndicator, int index) {
        boolean first = true;
        String dsaKey = null;
        String rsaKey = null;
        String pwd = null;
        for (Host host : this.getHosts()) {
            host.setIsLoading();
            if (host.isConnected()) {
                host.setLoadingDone();
                continue;
            }
            if (!first) {
                host.getSSH().setPasswords(dsaKey, rsaKey, pwd);
            }
            if (rootPane == null) {
                host.connect(null, progressIndicator, index);
            } else {
                host.connect(new SSHGui(rootPane, host, null), progressIndicator, index);
            }
            host.getSSH().waitForConnection();
            if (first) {
                if (host.getSSH().isConnectionCanceled()) {
                    return false;
                }
                if (host.isConnected()) {
                    dsaKey = host.getSSH().getLastDSAKey();
                    rsaKey = host.getSSH().getLastRSAKey();
                    pwd = host.getSSH().getLastPassword();
                }
            }
            first = false;
        }
        return true;
    }

    public String getMinLibvirtVersion() {
        String minVersion = null;
        for (Host host : this.hosts) {
            String version2 = host.getLibvirtVersion();
            if (version2 == null) continue;
            try {
                if (minVersion == null) {
                    minVersion = version2;
                    continue;
                }
                if (Tools.compareVersions(version2, minVersion) >= 0) continue;
                minVersion = version2;
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning(e.getMessage(), e);
            }
        }
        return minVersion;
    }

    public void setSavable(boolean savable) {
        this.savable = savable;
    }

    public boolean isSavable() {
        return this.savable;
    }

    public Set<Host> getProxyHosts() {
        return this.proxyHosts;
    }

    public void addProxyHost(Host host) {
        this.proxyHosts.add(host);
        host.setCluster(this);
    }

    public Host getProxyHostByName(String name) {
        for (Host h : this.proxyHosts) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }
}

