/*
 * Decompiled with CFR 0.152.
 */
package lcmc;

import java.util.ArrayList;
import java.util.Arrays;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.Resource;
import lcmc.gui.dialog.drbdConfig.Start;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.Tools;

public final class AddDrbdConfigDialog {
    private boolean canceled = false;
    private final DrbdInfo drbdInfo;
    private final BlockDevInfo blockDevInfo1;
    private final BlockDevInfo blockDevInfo2;

    public AddDrbdConfigDialog(DrbdInfo drbdInfo, BlockDevInfo blockDevInfo1, BlockDevInfo blockDevInfo2) {
        this.drbdInfo = drbdInfo;
        this.blockDevInfo1 = blockDevInfo1;
        this.blockDevInfo2 = blockDevInfo2;
    }

    public void showDialogs() {
        WizardDialog dialog;
        if (!this.drbdInfo.getDrbdResources().isEmpty() && this.drbdInfo.atLeastVersion("8.4")) {
            dialog = new Start(null, this.drbdInfo, this.blockDevInfo1, this.blockDevInfo2);
        } else {
            ArrayList<BlockDevInfo> bdis = new ArrayList<BlockDevInfo>(Arrays.asList(this.blockDevInfo1, this.blockDevInfo2));
            DrbdResourceInfo drbdResourceInfo = this.drbdInfo.getNewDrbdResource(DrbdVolumeInfo.getHostsFromBlockDevices(bdis));
            DrbdVolumeInfo dvi = this.drbdInfo.getNewDrbdVolume(drbdResourceInfo, bdis);
            drbdResourceInfo.addDrbdVolume(dvi);
            this.drbdInfo.addDrbdResource(drbdResourceInfo);
            this.drbdInfo.addDrbdVolume(dvi);
            dialog = new Resource(null, dvi);
        }
        Tools.getGUIData().expandTerminalSplitPane(0);
        while (true) {
            WizardDialog newdialog = (WizardDialog)dialog.showDialog();
            if (dialog.isPressedCancelButton()) {
                dialog.cancelDialog();
                this.canceled = true;
                Tools.getGUIData().expandTerminalSplitPane(1);
                if (newdialog == null) {
                    return;
                }
            } else if (dialog.isPressedFinishButton()) break;
            dialog = newdialog;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

