/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.File;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jssc.SerialNativeInterface;

public class SerialPortList {
    private static SerialNativeInterface serialInterface = new SerialNativeInterface();
    private static final Pattern PORTNAMES_REGEXP;
    private static final String PORTNAMES_PATH;
    private static final Comparator<String> PORTNAMES_COMPARATOR;

    public static String[] getPortNames() {
        return SerialPortList.getPortNames(PORTNAMES_PATH, PORTNAMES_REGEXP, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(String string) {
        return SerialPortList.getPortNames(string, PORTNAMES_REGEXP, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(Pattern pattern) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, pattern, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(Comparator<String> comparator) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, PORTNAMES_REGEXP, comparator);
    }

    public static String[] getPortNames(String string, Pattern pattern) {
        return SerialPortList.getPortNames(string, pattern, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(String string, Comparator<String> comparator) {
        return SerialPortList.getPortNames(string, PORTNAMES_REGEXP, comparator);
    }

    public static String[] getPortNames(Pattern pattern, Comparator<String> comparator) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, pattern, comparator);
    }

    public static String[] getPortNames(String string, Pattern pattern, Comparator<String> comparator) {
        if (string == null || pattern == null || comparator == null) {
            return new String[0];
        }
        if (SerialNativeInterface.getOsType() == 1) {
            return SerialPortList.getWindowsPortNames(pattern, comparator);
        }
        return SerialPortList.getUnixBasedPortNames(string, pattern, comparator);
    }

    private static String[] getWindowsPortNames(Pattern pattern, Comparator<String> comparator) {
        String[] stringArray = serialInterface.getSerialPortNames();
        if (stringArray == null) {
            return new String[0];
        }
        TreeSet<String> treeSet = new TreeSet<String>(comparator);
        for (String string : stringArray) {
            if (!pattern.matcher(string).find()) continue;
            treeSet.add(string);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    private static String[] getUnixBasedPortNames(String string, Pattern pattern, Comparator<String> comparator) {
        File[] fileArray;
        string = string.equals("") ? string : (string.endsWith("/") ? string : string + "/");
        String[] stringArray = new String[]{};
        File file = new File(string);
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()).length > 0) {
            TreeSet<String> treeSet = new TreeSet<String>(comparator);
            for (File file2 : fileArray) {
                String string2;
                long l;
                String string3 = file2.getName();
                if (file2.isDirectory() || file2.isFile() || !pattern.matcher(string3).find() || (l = serialInterface.openPort(string2 = string + string3, false)) < 0L && l != -1L) continue;
                if (l != -1L) {
                    serialInterface.closePort(l);
                }
                treeSet.add(string2);
            }
            stringArray = treeSet.toArray(stringArray);
        }
        return stringArray;
    }

    static {
        switch (SerialNativeInterface.getOsType()) {
            case 0: {
                PORTNAMES_REGEXP = Pattern.compile("(ttyS|ttyUSB|ttyACM|ttyAMA|rfcomm|ttyO)[0-9]{1,3}");
                PORTNAMES_PATH = "/dev/";
                break;
            }
            case 2: {
                PORTNAMES_REGEXP = Pattern.compile("[0-9]*|[a-z]*");
                PORTNAMES_PATH = "/dev/term/";
                break;
            }
            case 3: {
                PORTNAMES_REGEXP = Pattern.compile("tty.(serial|usbserial|usbmodem).*");
                PORTNAMES_PATH = "/dev/";
                break;
            }
            case 1: {
                PORTNAMES_REGEXP = Pattern.compile("");
                PORTNAMES_PATH = "";
                break;
            }
            default: {
                PORTNAMES_REGEXP = null;
                PORTNAMES_PATH = null;
            }
        }
        PORTNAMES_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string.equalsIgnoreCase(string2)) {
                    return string.compareTo(string2);
                }
                int n = Math.min(string.length(), string2.length());
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    char c;
                    char c2 = string.charAt(i - n2);
                    if (c2 == (c = string2.charAt(i - n3))) continue;
                    if (Character.isDigit(c2) && Character.isDigit(c)) {
                        int[] nArray;
                        int[] nArray2 = this.getNumberAndLastIndex(string, i - n2);
                        if (nArray2[0] != (nArray = this.getNumberAndLastIndex(string2, i - n3))[0]) {
                            return nArray2[0] - nArray[0];
                        }
                        if (string.length() < string2.length()) {
                            i = nArray2[1];
                            n3 = nArray2[1] - nArray[1];
                            continue;
                        }
                        i = nArray[1];
                        n2 = nArray[1] - nArray2[1];
                        continue;
                    }
                    if (Character.toLowerCase(c2) - Character.toLowerCase(c) == 0) continue;
                    return Character.toLowerCase(c2) - Character.toLowerCase(c);
                }
                return string.compareToIgnoreCase(string2);
            }

            private int[] getNumberAndLastIndex(String string, int n) {
                String string2 = "";
                int[] nArray = new int[]{-1, n};
                for (int i = n; i < string.length(); ++i) {
                    nArray[1] = i;
                    char c = string.charAt(i);
                    if (!Character.isDigit(c)) break;
                    string2 = string2 + c;
                }
                try {
                    nArray[0] = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return nArray;
            }
        };
    }
}

