/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.jmock.builder.BuilderNamespace;
import org.jmock.builder.IdentityBuilder;
import org.jmock.builder.InvocationMockerBuilder;
import org.jmock.builder.InvocationMockerDescriber;
import org.jmock.builder.MatchBuilder;
import org.jmock.builder.NameMatchBuilder;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicMock;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;

public class Mock
implements DynamicMock,
BuilderNamespace {
    DynamicMock coreMock;
    HashMap idTable = new HashMap();

    public Mock(Class clazz) {
        this(clazz, CoreMock.mockNameFromClass(clazz));
    }

    public Mock(Class clazz, String string) {
        this(new CoreMock(clazz, string));
    }

    public Mock(DynamicMock dynamicMock) {
        this.coreMock = dynamicMock;
    }

    @Override
    public Class getMockedType() {
        return this.coreMock.getMockedType();
    }

    @Override
    public Object proxy() {
        return this.coreMock.proxy();
    }

    public String toString() {
        return this.coreMock.toString();
    }

    @Override
    public void verify() {
        this.coreMock.verify();
    }

    @Override
    public void addInvokable(Invokable invokable) {
        this.coreMock.addInvokable(invokable);
    }

    public NameMatchBuilder stubs() {
        return this.addNewInvocationMocker();
    }

    public NameMatchBuilder expects(InvocationMatcher invocationMatcher) {
        NameMatchBuilder nameMatchBuilder = this.addNewInvocationMocker();
        nameMatchBuilder.match(invocationMatcher);
        return nameMatchBuilder;
    }

    private NameMatchBuilder addNewInvocationMocker() {
        InvocationMocker invocationMocker = new InvocationMocker(new InvocationMockerDescriber());
        this.addInvokable(invocationMocker);
        return new InvocationMockerBuilder(invocationMocker, this, this.getMockedType());
    }

    @Override
    public void setDefaultStub(Stub stub) {
        this.coreMock.setDefaultStub(stub);
    }

    @Override
    public void reset() {
        this.idTable.clear();
        this.coreMock.reset();
    }

    @Override
    public MatchBuilder lookupID(String string) {
        if (!this.idTable.containsKey(string)) {
            throw new AssertionFailedError("no expected invocation named '" + string + "'");
        }
        return (MatchBuilder)this.idTable.get(string);
    }

    @Override
    public void registerUniqueID(String string, MatchBuilder matchBuilder) {
        if (this.idTable.containsKey(string)) {
            throw new AssertionFailedError("duplicate invocation named \"" + string + "\"");
        }
        this.storeID(string, matchBuilder);
    }

    @Override
    public void registerMethodName(String string, MatchBuilder matchBuilder) {
        this.storeID(string, matchBuilder);
    }

    private void storeID(String string, IdentityBuilder identityBuilder) {
        this.idTable.put(string, identityBuilder);
    }
}

