/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSLabel {
    Unknown("", 128),
    Standard("standard label", 0),
    Compressed("compressed label", 192),
    Extended("extended label", 64);

    static final int LABEL_MASK = 192;
    static final int LABEL_NOT_MASK = 63;
    private final String _externalName;
    private final int _index;

    private DNSLabel(String string2, int n2) {
        this._externalName = string2;
        this._index = n2;
    }

    public String externalName() {
        return this._externalName;
    }

    public int indexValue() {
        return this._index;
    }

    public static DNSLabel labelForByte(int n) {
        int n2 = n & 0xC0;
        for (DNSLabel dNSLabel : DNSLabel.values()) {
            if (dNSLabel._index != n2) continue;
            return dNSLabel;
        }
        return Unknown;
    }

    public static int labelValue(int n) {
        return n & 0x3F;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }
}

