/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.macosx;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookSourceContact;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.EditableContactDetail;
import net.java.sip.communicator.service.contactsource.EditableSourceContact;

public class MacOSXAddrBookContactDetail
extends EditableContactDetail {
    private final int property;
    private String id;
    private String subPropertyLabel;

    public MacOSXAddrBookContactDetail(int property, String contactDetailValue, ContactDetail.Category category, ContactDetail.SubCategory[] subCategories, String subPropertyLabel, String id) {
        super(contactDetailValue, category, subCategories);
        this.property = property;
        this.subPropertyLabel = subPropertyLabel;
        this.id = id;
    }

    public static boolean isMultiline(ContactDetail.Category category) {
        switch (category) {
            case Personal: {
                return false;
            }
            case Organization: {
                return false;
            }
            case Email: {
                return true;
            }
            case InstantMessaging: {
                return true;
            }
            case Phone: {
                return true;
            }
            case Address: {
                return true;
            }
        }
        return false;
    }

    public void setDetail(String value) {
        if (MacOSXAddrBookContactDetail.isMultiline(this.getCategory())) {
            EditableSourceContact sourceContact = this.getSourceContact();
            if (sourceContact != null && sourceContact instanceof MacOSXAddrBookSourceContact) {
                List details = ((MacOSXAddrBookSourceContact)sourceContact).getContactDetails(this.getCategory());
                boolean isAddress = this.property == 22;
                boolean isHomeAddress = this.containsSubCategory(ContactDetail.SubCategory.Home);
                ArrayList<String> values = new ArrayList<String>();
                for (ContactDetail cd : details) {
                    boolean isModifiedAddressOrGenericDetail = true;
                    if (isAddress && (isHomeAddress && !cd.containsSubCategory(ContactDetail.SubCategory.Home) || !isHomeAddress && !cd.containsSubCategory(ContactDetail.SubCategory.Work))) {
                        isModifiedAddressOrGenericDetail = false;
                    }
                    String det = cd.getDetail();
                    for (ContactDetail.SubCategory sub : cd.getSubCategories()) {
                        String label = MacOSXAddrBookContactQuery.getLabel(this.property, sub, this.subPropertyLabel);
                        if (label == null) continue;
                        if (this.getSubCategories().contains(sub) && isModifiedAddressOrGenericDetail) {
                            values.add(value);
                        } else {
                            values.add(det);
                        }
                        values.add(label);
                        if (!isAddress || !(cd instanceof MacOSXAddrBookContactDetail)) continue;
                        values.add(((MacOSXAddrBookContactDetail)cd).getSubPropertyLabel());
                    }
                }
                MacOSXAddrBookContactQuery.setProperty(this.id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[this.property], this.subPropertyLabel, values.toArray(new Object[values.size()]));
            }
        } else {
            MacOSXAddrBookContactQuery.setProperty(this.id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[this.property], null, value);
        }
        super.setDetail(value);
    }

    public String getSubPropertyLabel() {
        return this.subPropertyLabel;
    }

    public final int getProperty() {
        return this.property;
    }
}

