/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnection;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PacketReader {
    private static final Logger LOGGER = Logger.getLogger(PacketReader.class.getName());
    private Thread readerThread;
    private ExecutorService listenerExecutor;
    private AbstractConnection connection;
    protected XmlPullParser parser;
    protected boolean done;
    private String streamRoot;
    private Semaphore connectionSemaphore;

    public PacketReader(AbstractConnection connection, String streamRoot) {
        this.connection = connection;
        this.streamRoot = streamRoot;
        this.init();
    }

    protected void init() {
        this.done = false;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.resetParser();
    }

    public void startup() throws XMPPException {
        this.connectionSemaphore = new Semaphore(1);
        this.readerThread.start();
        try {
            if (!this.connection.connected) {
                this.connectionSemaphore.acquire();
            }
            int waitTime = SmackConfiguration.getPacketReplyTimeout();
            if (!this.connection.connected) {
                this.connectionSemaphore.tryAcquire(3 * waitTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.connection.connected) {
            throw new XMPPException("Connection failed. No response from server.");
        }
    }

    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener listener : this.connection.getConnectionListeners()) {
                try {
                    listener.connectionClosed();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "faulty listener", e);
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    void cleanup() {
        this.connection.recvListeners.clear();
        this.connection.collectors.clear();
    }

    void notifyConnectionError(Exception e) {
        this.done = true;
        this.connection.shutdown(new Presence(Presence.Type.unavailable));
        LOGGER.log(Level.SEVERE, "Closes the connection temporary", e);
        for (ConnectionListener listener : this.connection.getConnectionListeners()) {
            try {
                listener.connectionClosedOnError(e);
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "faulty listener", e2);
            }
        }
    }

    protected void notifyReconnection() {
        for (ConnectionListener listener : this.connection.getConnectionListeners()) {
            try {
                listener.reconnectionSuccessful();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "faulty listener", e);
            }
        }
    }

    protected void resetParser() {
        try {
            this.parser = new MXParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xppe) {
            LOGGER.log(Level.SEVERE, "parser error", xppe);
        }
    }

    private void parsePackets(Thread thread) {
        block5: {
            try {
                int eventType = this.parser.getEventType();
                do {
                    if (eventType == 3 && this.streamRoot.equals(this.parser.getName())) {
                        this.connection.disconnect();
                    } else {
                        this.doParsePackets(this.parser);
                    }
                    eventType = this.parser.next();
                } while (!this.done && eventType != 1 && thread == this.readerThread);
            }
            catch (Exception e) {
                if (this.done) break block5;
                this.notifyConnectionError(e);
            }
        }
    }

    protected void doParsePackets(XmlPullParser parser) throws Exception {
        int eventType = parser.getEventType();
        if (eventType == 2) {
            if (parser.getName().equals("message")) {
                this.processPacket(PacketParserUtils.parseMessage(parser));
            } else if (parser.getName().equals("iq")) {
                this.processPacket(PacketParserUtils.parseIQ(parser, this.connection));
            } else if (parser.getName().equals("presence")) {
                this.processPacket(PacketParserUtils.parsePresence(parser));
            } else {
                if (parser.getName().equals("error")) {
                    throw new XMPPException(PacketParserUtils.parseStreamError(parser));
                }
                if (parser.getName().equals("features")) {
                    this.parseFeatures(parser);
                } else if (parser.getName().equals("failure")) {
                    SASLMechanism.Failure failure = PacketParserUtils.parseSASLFailure(parser);
                    this.processPacket(failure);
                    this.connection.getSASLAuthentication().authenticationFailed(failure.getCondition());
                } else if (parser.getName().equals("challenge")) {
                    String challengeData = parser.nextText();
                    this.processPacket(new SASLMechanism.Challenge(challengeData));
                    this.connection.getSASLAuthentication().challengeReceived(challengeData);
                } else if (parser.getName().equals("success")) {
                    this.processPacket(new SASLMechanism.Success(parser.nextText()));
                    this.connection.onSuccessReceived();
                    this.connection.getSASLAuthentication().authenticated();
                }
            }
        }
    }

    void releaseConnectionIDLock() {
        this.connectionSemaphore.release();
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector collector : this.connection.getPacketCollectors()) {
            try {
                collector.processPacket(packet);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Faulty PacketCollector", e);
            }
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    private void parseFeatures(XmlPullParser parser) throws Exception {
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 3 && "features".equals(parser.getName())) {
                done = true;
            }
            this.doParseFeatures(parser);
        }
    }

    protected void doParseFeatures(XmlPullParser parser) throws Exception {
        int eventType = parser.getEventType();
        if (eventType == 2) {
            if (parser.getName().equals("mechanisms")) {
                this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(parser));
            } else if (parser.getName().equals("bind")) {
                this.connection.getSASLAuthentication().bindingRequired();
            } else if (parser.getName().equals("session")) {
                this.connection.getSASLAuthentication().sessionsSupported();
            } else if (parser.getName().equals("register")) {
                this.connection.getAccountManager().setSupportsAccountCreation(true);
            }
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (Connection.ListenerWrapper listenerWrapper : ((PacketReader)PacketReader.this).connection.recvListeners.values()) {
                listenerWrapper.notifyListener(this.packet);
            }
        }
    }
}

