/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.chatconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JLabel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ChatConfigActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ChatConfigActivator.class);
    public static BundleContext bundleContext;
    private static ConfigurationService configService;
    private static ResourceManagementService resourceService;
    private static final Map<String, ReplacementService> replacementSourcesMap;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.chatconfig.DISABLED";

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        if (ChatConfigActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("FORM_TYPE", "GENERAL_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.chatconfig.ChatConfigPanel", this.getClass().getClassLoader(), "plugin.chatconfig.PLUGIN_ICON", "plugin.chatconfig.TITLE", 40), properties);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Chat Configuration: [ STARTED ]");
        }
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static Component createConfigSectionComponent(String labelText) {
        JLabel label = new JLabel(labelText);
        label.setFont(label.getFont().deriveFont(1));
        label.setAlignmentX(1.0f);
        TransparentPanel parentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        parentPanel.add((Component)label, "North");
        parentPanel.setPreferredSize(new Dimension(180, 25));
        return parentPanel;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            ServiceReference configReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(configReference);
        }
        return configService;
    }

    public static Map<String, ReplacementService> getReplacementSources() {
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ReplacementService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("Error : " + (Object)((Object)e)));
        }
        if (serRefs != null) {
            for (int i = 0; i < serRefs.length; ++i) {
                ReplacementService replacementSources = (ReplacementService)bundleContext.getService(serRefs[i]);
                replacementSourcesMap.put((String)serRefs[i].getProperty("SOURCE"), replacementSources);
            }
        }
        return replacementSourcesMap;
    }

    static {
        replacementSourcesMap = new Hashtable<String, ReplacementService>();
    }
}

