/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.neomedia.recording.RecorderImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class CallRecordingConfigForm
extends TransparentPanel
implements ActionListener,
DocumentListener {
    private static final Logger logger = Logger.getLogger(CallRecordingConfigForm.class);
    private static final ResourceManagementService resources = NeomediaActivator.getResources();
    private static final long serialVersionUID = 0L;
    private JButton callDirChooseButton;
    private JTextField callDirTextField;
    private final SipCommFileChooser dirChooser;
    private JComboBox formatsComboBox;
    private JCheckBox saveCallsToCheckBox;
    private String savedCallsDir;

    public CallRecordingConfigForm() {
        super((LayoutManager)new BorderLayout());
        this.initComponents();
        this.loadValues();
        this.dirChooser = GenericFileDialog.create(null, (String)resources.getI18NString("plugin.callrecordingconfig.CHOOSE_DIR"), (int)0);
        this.dirChooser.setSelectionMode(1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.saveCallsToCheckBox) {
            boolean selected = this.saveCallsToCheckBox.isSelected();
            this.callDirTextField.setEnabled(selected);
            this.callDirChooseButton.setEnabled(selected);
            if (selected) {
                try {
                    this.changeCallsDir(NeomediaActivator.getFileAccessService().getDefaultDownloadDirectory(), true);
                }
                catch (IOException iOException) {}
            } else {
                NeomediaActivator.getConfigurationService().setProperty("net.java.sip.communicator.impl.neomedia.SAVED_CALLS_PATH", null);
                this.callDirTextField.setText(null);
            }
        } else if (source == this.callDirChooseButton) {
            File newDir = this.dirChooser.getFileFromDialog();
            this.changeCallsDir(newDir, true);
        } else if (source == this.callDirTextField) {
            File newDir = new File(this.callDirTextField.getText());
            this.changeCallsDir(newDir, true);
        }
    }

    private boolean changeCallsDir(File dir, boolean changeCallDirTextField) {
        if (dir != null && dir.isDirectory()) {
            this.savedCallsDir = dir.getAbsolutePath();
            if (changeCallDirTextField) {
                this.callDirTextField.setText(this.savedCallsDir);
            }
            NeomediaActivator.getConfigurationService().setProperty("net.java.sip.communicator.impl.neomedia.SAVED_CALLS_PATH", (Object)this.savedCallsDir);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calls directory changed to " + this.savedCallsDir));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Calls directory not changed.");
        }
        return false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private Component createFormatsComboBox() {
        DefaultComboBoxModel<String> formatsComboBoxModel = new DefaultComboBoxModel<String>(RecorderImpl.SUPPORTED_FORMATS);
        this.formatsComboBox = new JComboBox();
        this.formatsComboBox.setPreferredSize(new Dimension(200, 30));
        this.formatsComboBox.setModel(formatsComboBoxModel);
        this.formatsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    NeomediaActivator.getConfigurationService().setProperty("net.java.sip.communicator.impl.neomedia.Recorder.FORMAT", event.getItem());
                }
            }
        });
        return this.formatsComboBox;
    }

    private void initComponents() {
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        JLabel formatsLabel = new JLabel(resources.getI18NString("plugin.callrecordingconfig.SUPPORTED_FORMATS"));
        this.saveCallsToCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.callrecordingconfig.SAVE_CALLS"));
        this.saveCallsToCheckBox.addActionListener(this);
        labelsPanel.add(formatsLabel);
        labelsPanel.add(this.saveCallsToCheckBox);
        TransparentPanel callDirPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.callDirTextField = new JTextField();
        this.callDirTextField.addActionListener(this);
        callDirPanel.add(this.callDirTextField);
        this.callDirChooseButton = new JButton(new ImageIcon(resources.getImageInBytes("plugin.notificationconfig.FOLDER_ICON")));
        this.callDirChooseButton.addActionListener(this);
        callDirPanel.add((Component)this.callDirChooseButton, "East");
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        valuesPanel.add(this.createFormatsComboBox());
        valuesPanel.add((Component)callDirPanel);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.add((Component)labelsPanel, "West");
        mainPanel.add((Component)valuesPanel, "Center");
        this.add((Component)mainPanel, "North");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        File insertedFile = new File(this.callDirTextField.getText());
        if (insertedFile.exists()) {
            this.changeCallsDir(insertedFile, false);
        }
    }

    private void loadValues() {
        ConfigurationService configuration = NeomediaActivator.getConfigurationService();
        String format = configuration.getString("net.java.sip.communicator.impl.neomedia.Recorder.FORMAT");
        this.formatsComboBox.setSelectedItem(format == null ? "mp3" : format);
        this.savedCallsDir = configuration.getString("net.java.sip.communicator.impl.neomedia.SAVED_CALLS_PATH");
        this.saveCallsToCheckBox.setSelected(this.savedCallsDir != null);
        this.callDirTextField.setText(this.savedCallsDir);
        this.callDirTextField.setEnabled(this.saveCallsToCheckBox.isSelected());
        this.callDirTextField.getDocument().addDocumentListener(this);
        this.callDirChooseButton.setEnabled(this.saveCallsToCheckBox.isSelected());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        File insertedFile = new File(this.callDirTextField.getText());
        if (insertedFile.exists()) {
            this.changeCallsDir(insertedFile, false);
        }
    }
}

