/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.LabelTableCellRenderer;
import net.java.sip.communicator.impl.gui.customcontrols.SIPCommMsgTextArea;
import net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms.NewChatRoom;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.util.skin.Skinnable;

public class SelectAccountPanel
extends TransparentPanel
implements Skinnable {
    private static final long serialVersionUID = 4717173525426074284L;
    private static final int PROTOCOL_COLUMN_INDEX = 0;
    private static final int ACCOUNT_COLUMN_INDEX = 1;
    private final JScrollPane tablePane = new JScrollPane(20, 31);
    private final JTable accountsTable;
    private final AccountsTableModel tableModel = new AccountsTableModel();
    private final NewChatRoom joinChatRoom;
    private final Iterator<ChatRoomProviderWrapper> chatRoomProvidersList;
    private final JPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private final JPanel rightPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private final JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_CHAT_ICON)));
    private final SIPCommMsgTextArea infoLabel = new SIPCommMsgTextArea(GuiActivator.getResources().getI18NString("service.gui.SELECT_PROVIDERS_FOR_CHAT_ROOM"));
    private final JLabel infoTitleLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_ACCOUNT"), 0);

    public SelectAccountPanel(NewChatRoom joinChatRoom, Iterator<ChatRoomProviderWrapper> chatRoomProviders) {
        super((LayoutManager)new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.joinChatRoom = joinChatRoom;
        this.chatRoomProvidersList = chatRoomProviders;
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10));
        this.infoLabel.setEditable(false);
        Font font = this.infoTitleLabel.getFont();
        this.infoTitleLabel.setFont(font.deriveFont(1, font.getSize2D() + 6.0f));
        this.labelsPanel.add(this.infoTitleLabel);
        this.labelsPanel.add(this.infoLabel);
        this.rightPanel.add((Component)this.labelsPanel, "North");
        this.rightPanel.add((Component)this.tablePane, "Center");
        this.add(this.iconLabel, "West");
        this.add(this.rightPanel, "Center");
        this.accountsTable = new JTable(this.tableModel){
            private static final long serialVersionUID = 6321836989166142791L;

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        this.tableInit();
    }

    private void tableInit() {
        this.accountsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.tableModel.addColumn(GuiActivator.getResources().getI18NString("service.gui.PROTOCOL"));
        this.tableModel.addColumn(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT"));
        while (this.chatRoomProvidersList.hasNext()) {
            ChatRoomProviderWrapper provider = this.chatRoomProvidersList.next();
            String pName = provider.getName();
            JLabel protocolLabel = new JLabel();
            protocolLabel.setText(pName);
            byte[] providerImage = provider.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16");
            if (providerImage != null) {
                protocolLabel.setIcon(new ImageIcon(providerImage));
            }
            this.tableModel.addRow(new Object[]{protocolLabel, provider});
        }
        this.accountsTable.setRowHeight(22);
        this.accountsTable.getColumnModel().getColumn(1).setCellRenderer(new LabelTableCellRenderer());
        this.accountsTable.getColumnModel().getColumn(0).sizeWidthToFit();
        this.accountsTable.getColumnModel().getColumn(0).setCellRenderer(new LabelTableCellRenderer());
        this.accountsTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.tablePane.getViewport().add(this.accountsTable);
        if (this.accountsTable.getModel().getRowCount() == 0) {
            JTextArea noAccountsTextArea = new JTextArea(GuiActivator.getResources().getI18NString("service.gui.NO_GROUP_CHAT_ACCOUNT_AVAILABLE"));
            noAccountsTextArea.setLineWrap(true);
            noAccountsTextArea.setPreferredSize(new Dimension(400, 200));
            noAccountsTextArea.setOpaque(false);
            this.rightPanel.add((Component)noAccountsTextArea, "South");
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.accountsTable.getSelectionModel().addListSelectionListener(listener);
    }

    public boolean isRowSelected() {
        return this.accountsTable.getSelectedRow() != -1;
    }

    public void initSelectedAccount() {
        TableModel model = this.accountsTable.getModel();
        int selectedRow = this.accountsTable.getSelectedRow();
        if (selectedRow != -1) {
            this.joinChatRoom.setChatRoomProvider((ChatRoomProviderWrapper)model.getValueAt(selectedRow, 1));
        }
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_CHAT_ICON)));
    }

    private static class AccountsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4259505654018472178L;

        private AccountsTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

