/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JList;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactRoleIcon;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListCellRenderer;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;

public class ChatContactCellRenderer
extends ContactListCellRenderer {
    private static final Color COLOR_AVAILABILITY_THRESHOLD = Color.BLACK;
    private static final Color COLOR_AWAY_THRESHOLD = Color.GRAY;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.index = index;
        this.rightLabel.setIcon(null);
        ChatContact chatContact = (ChatContact)value;
        if (chatContact == null) {
            return this;
        }
        ChatRoomMember member = null;
        if (chatContact.getDescriptor() instanceof ChatRoomMember) {
            member = (ChatRoomMember)chatContact.getDescriptor();
        }
        this.setPreferredSize(new Dimension(20, 30));
        String displayName = chatContact.getName();
        if (displayName == null || displayName.length() < 1) {
            displayName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN");
        }
        this.nameLabel.setFont(this.getFont().deriveFont(0));
        this.nameLabel.setText(displayName);
        if (member != null) {
            int presenceStatus;
            ChatRoomMemberRole memberRole = member.getRole();
            if (memberRole != null) {
                this.nameLabel.setIcon(ChatContactRoleIcon.getRoleIcon(memberRole));
            }
            if ((presenceStatus = member.getPresenceStatus().getStatus()) >= 50) {
                this.nameLabel.setForeground(COLOR_AVAILABILITY_THRESHOLD);
            } else if (presenceStatus >= 36) {
                this.nameLabel.setForeground(COLOR_AWAY_THRESHOLD);
            }
        } else if (this.contactForegroundColor != null) {
            this.nameLabel.setForeground(this.contactForegroundColor);
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
        ImageIcon avatar = chatContact.getAvatar();
        if (avatar != null) {
            this.rightLabel.setIcon(avatar);
        } else if (member != null) {
            ChatRoom memberChatRoom = member.getChatRoom();
            ProtocolProviderService protocolProvider = memberChatRoom.getParentProvider();
            if (chatContact.getName().equals(memberChatRoom.getUserNickname())) {
                ChatRoomMemberRole role;
                OperationSetServerStoredAccountInfo opSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
                if (opSet != null) {
                    Iterator itr;
                    try {
                        itr = opSet.getAllAvailableDetails();
                    }
                    catch (IllegalStateException isex) {
                        itr = null;
                    }
                    if (itr != null) {
                        while (itr.hasNext()) {
                            ServerStoredDetails.GenericDetail detail = (ServerStoredDetails.GenericDetail)itr.next();
                            if (!(detail instanceof ServerStoredDetails.BinaryDetail)) continue;
                            ServerStoredDetails.BinaryDetail bin = (ServerStoredDetails.BinaryDetail)detail;
                            byte[] binBytes = bin.getBytes();
                            if (binBytes == null) break;
                            this.rightLabel.setIcon(ImageUtils.getScaledRoundedIcon((byte[])binBytes, (int)25, (int)25));
                            break;
                        }
                    }
                }
                try {
                    role = memberChatRoom.getUserRole();
                }
                catch (UnsupportedOperationException uoex) {
                    role = member.getRole();
                }
                if (role != null) {
                    this.nameLabel.setIcon(ChatContactRoleIcon.getRoleIcon(role));
                }
            } else {
                byte[] cImage;
                Contact c;
                OperationSetPersistentPresence opSet = (OperationSetPersistentPresence)protocolProvider.getOperationSet(OperationSetPersistentPresence.class);
                if (opSet != null && (c = opSet.findContactByID(member.getContactAddress())) != null && (cImage = c.getImage()) != null) {
                    this.rightLabel.setIcon(ImageUtils.getScaledRoundedIcon((byte[])cImage, (int)25, (int)25));
                }
            }
        }
        int listWidth = list.getWidth();
        this.setBounds(0, 0, listWidth - 2, 30);
        this.nameLabel.setBounds(0, 0, listWidth - 28, 17);
        this.rightLabel.setBounds(listWidth - 28, 0, 25, 30);
        this.isLeaf = true;
        this.isSelected = isSelected;
        return this;
    }
}

