/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.call.CallContainer;
import net.java.sip.communicator.impl.gui.main.call.CallDialog;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallTitleListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ContactPhotoPanel;
import net.java.sip.communicator.impl.gui.main.chat.ConversationTabbedPane;
import net.java.sip.communicator.impl.gui.main.chat.toolBars.MainToolBar;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;

public class SingleWindowContainer
extends TransparentPanel
implements ChatContainer,
CallContainer,
CallTitleListener,
ChangeListener {
    private final List<ChatChangeListener> chatChangeListeners = new Vector<ChatChangeListener>();
    private final ContactPhotoPanel contactPhotoPanel;
    private int conversationCount = 0;
    private final Logger logger = Logger.getLogger(SingleWindowContainer.class);
    private MainToolBar mainToolBar;
    private final ConversationTabbedPane tabbedPane;

    public SingleWindowContainer() {
        super((LayoutManager)new BorderLayout());
        this.setPreferredSize(new Dimension(620, 580));
        this.tabbedPane = new ConversationTabbedPane();
        this.contactPhotoPanel = new ContactPhotoPanel();
        this.add(this.createToolbar(), "North");
        this.tabbedPane.addChangeListener(this);
        this.add((Component)((Object)this.tabbedPane));
    }

    @Override
    public void addCallPanel(CallPanel callPanel) {
        ++this.conversationCount;
        callPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        callPanel.addCallTitleListener(this);
        this.addConversationTab(callPanel.getCallTitle(), null, (Component)((Object)callPanel), true);
        callPanel.requestFocus();
    }

    @Override
    public void addChat(ChatPanel chatPanel) {
        ChatSession chatSession = chatPanel.getChatSession();
        this.addConversationTab(chatSession.getChatName(), chatSession.getChatStatusIcon(), (Component)((Object)chatPanel), false);
        ++this.conversationCount;
        chatPanel.setShown(true);
        for (ChatChangeListener l : this.chatChangeListeners) {
            l.chatChanged(chatPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChatChangeListener(ChatChangeListener listener) {
        List<ChatChangeListener> list = this.chatChangeListeners;
        synchronized (list) {
            if (!this.chatChangeListeners.contains(listener)) {
                this.chatChangeListeners.add(listener);
            }
        }
    }

    private void addConversationTab(String name, Icon icon, Component conversation, boolean isSelected) {
        Component currentConversation = this.getCurrentConversation();
        this.tabbedPane.addTab(name, icon, conversation);
        this.tabbedPane.getParent().validate();
        this.tabbedPane.setSelectedComponent(currentConversation != null && !isSelected ? currentConversation : conversation);
    }

    @Override
    public void callTitleChanged(CallPanel callPanel) {
        int i = this.tabbedPane.indexOfComponent((Component)((Object)callPanel));
        if (i > -1) {
            this.tabbedPane.setTitleAt(i, callPanel.getCallTitle());
        }
    }

    @Override
    public void close(CallPanel callPanel, boolean delay) {
        if (delay) {
            Timer timer = new Timer(5000, new CloseCallListener(callPanel));
            timer.setRepeats(false);
            timer.start();
        } else {
            this.removeConversation((Component)((Object)callPanel));
        }
    }

    public boolean containsFocusOwner() {
        ChatPanel chat = this.getCurrentChat();
        return chat != null && chat.getChatWritePanel().getEditorPane().isFocusOwner();
    }

    private Component createToolbar() {
        this.mainToolBar = new MainToolBar(this);
        this.mainToolBar.setVisible(false);
        TransparentPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        northPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        northPanel.setPreferredSize(new Dimension(500, 35));
        northPanel.setVisible(ConfigurationUtils.isChatToolbarVisible());
        northPanel.add((Component)((Object)this.mainToolBar), "East");
        northPanel.add((Component)this.contactPhotoPanel, "West");
        return northPanel;
    }

    @Override
    public void ensureSize(Component component, int width, int height) {
    }

    @Override
    public int getChatCount() {
        return this.conversationCount;
    }

    @Override
    public List<ChatPanel> getChats() {
        ArrayList<ChatPanel> chatPanels = new ArrayList<ChatPanel>();
        if (this.tabbedPane.getTabCount() > 0) {
            int componentCount = this.tabbedPane.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = this.tabbedPane.getComponent(i);
                if (!(c instanceof ChatPanel)) continue;
                chatPanels.add((ChatPanel)((Object)c));
            }
        }
        return chatPanels;
    }

    @Override
    public ChatPanel getCurrentChat() {
        Component c = this.getCurrentConversation();
        if (c instanceof ChatPanel) {
            return (ChatPanel)((Object)c);
        }
        return null;
    }

    private Component getCurrentConversation() {
        if (this.tabbedPane.getTabCount() > 0) {
            return this.tabbedPane.getSelectedComponent();
        }
        return null;
    }

    @Override
    public JFrame getFrame() {
        return GuiActivator.getUIService().getMainFrame();
    }

    private void highlightTab(ChatPanel chatPanel) {
        int tabIndex = this.tabbedPane.indexOfComponent((Component)((Object)chatPanel));
        ++chatPanel.unreadMessageNumber;
        this.tabbedPane.highlightTab(tabIndex, chatPanel.unreadMessageNumber);
    }

    @Override
    public boolean isFullScreen() {
        return CallDialog.isFullScreen(this.getFrame());
    }

    @Override
    public void openChat(ChatPanel chatPanel, boolean setSelected) {
        MainFrame mainWindow = GuiActivator.getUIService().getMainFrame();
        if (mainWindow.getExtendedState() != 1) {
            if (ConfigurationUtils.isAutoPopupNewMessage() || setSelected) {
                mainWindow.toFront();
            }
        } else {
            String chatWindowTitle;
            if (setSelected) {
                mainWindow.setExtendedState(0);
                mainWindow.toFront();
            }
            if (!(chatWindowTitle = "TEST").startsWith("*")) {
                this.setTitle("*" + chatWindowTitle);
            }
        }
        if (setSelected) {
            this.setCurrentChat(chatPanel);
        } else if (!this.getCurrentChat().equals(chatPanel) && this.tabbedPane.getTabCount() > 0) {
            this.highlightTab(chatPanel);
        }
    }

    @Override
    public void pack() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeAllChats() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Remove all tabs from the chat window.");
        }
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.removeAll();
            this.conversationCount = 0;
            if (this.tabbedPane.getTabCount() == 0) {
                this.setToolbarVisible(false);
            }
        }
    }

    @Override
    public void removeChat(ChatPanel chatPanel) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removes chat for contact: " + chatPanel.getChatSession().getChatName()));
        }
        this.removeConversation((Component)((Object)chatPanel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChatChangeListener(ChatChangeListener listener) {
        List<ChatChangeListener> list = this.chatChangeListeners;
        synchronized (list) {
            this.chatChangeListeners.remove(listener);
        }
    }

    private void removeConversation(Component c) {
        int index = this.tabbedPane.indexOfComponent(c);
        if (index > -1) {
            this.tabbedPane.removeTabAt(index);
            --this.conversationCount;
        }
        if (this.tabbedPane.getTabCount() == 0) {
            this.setToolbarVisible(false);
        }
    }

    @Override
    public void setChatIcon(ChatPanel chatPanel, Icon icon) {
    }

    @Override
    public void setChatTitle(ChatPanel chatPanel, String title) {
    }

    @Override
    public void setCurrentChat(ChatPanel chatPanel) {
        ChatSession chatSession = chatPanel.getChatSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set current chat panel to: " + chatSession.getChatName()));
        }
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedComponent((Component)((Object)chatPanel));
        }
        this.setTitle(chatSession.getChatName());
        this.contactPhotoPanel.setChatSession(chatSession);
        chatPanel.requestFocusInWriteArea();
        for (ChatChangeListener l : this.chatChangeListeners) {
            l.chatChanged(chatPanel);
        }
    }

    @Override
    public void setFullScreen(boolean fullScreen) {
    }

    public void setTabIcon(ChatPanel chatPanel, Icon icon) {
        int index = this.tabbedPane.indexOfComponent((Component)((Object)chatPanel));
        this.tabbedPane.setIconAt(index, icon);
    }

    public void setTabTitle(ChatPanel chatPanel, String title) {
        int index = this.tabbedPane.indexOfComponent((Component)((Object)chatPanel));
        if (index > -1) {
            this.tabbedPane.setTitleAt(index, title);
        }
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setToolbarVisible(boolean isVisible) {
        this.mainToolBar.setVisible(isVisible);
        this.contactPhotoPanel.setVisible(isVisible);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        int index = this.tabbedPane.getSelectedIndex();
        if (index > -1) {
            Component c = this.tabbedPane.getComponentAt(index);
            this.setToolbarVisible(c instanceof ChatPanel);
        }
    }

    @Override
    public void updateHistoryButtonState(ChatPanel chatPanel) {
        this.mainToolBar.changeHistoryButtonsState(chatPanel);
    }

    private class CloseCallListener
    implements ActionListener {
        private final CallPanel callPanel;

        public CloseCallListener(CallPanel callPanel) {
            this.callPanel = callPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SingleWindowContainer.this.removeConversation((Component)((Object)this.callPanel));
        }
    }
}

