/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.util.skin.Skinnable;

class SIPCommSplitPaneDivider
extends BasicSplitPaneDivider
implements Skinnable {
    private BufferedImage horizontalDivider = ImageLoader.getImage(ImageLoader.SPLITPANE_HORIZONTAL);
    private BufferedImage verticalDivider = ImageLoader.getImage(ImageLoader.SPLITPANE_VERTICAL);

    public SIPCommSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new DividerLayout());
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (this.getOrientationFromSuper() == 0) {
            g.drawImage(this.horizontalDivider, (this.getWidth() - this.horizontalDivider.getWidth(null)) / 2, clip.y + (this.getHeight() - this.horizontalDivider.getHeight(null)) / 2, this.horizontalDivider.getWidth(null), this.horizontalDivider.getHeight(null), null);
        } else {
            g.drawImage(this.verticalDivider, clip.x + (this.getWidth() - this.verticalDivider.getWidth(null)) / 2, (this.getHeight() - this.verticalDivider.getHeight(null)) / 2, this.verticalDivider.getWidth(null), this.verticalDivider.getHeight(null), null);
        }
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                block7: {
                    JSplitPane splitPane = SIPCommSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block7;
                    int oneTouchSize = SIPCommSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = SIPCommSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(SIPCommSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }
        };
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                block7: {
                    JSplitPane splitPane = SIPCommSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block7;
                    int oneTouchSize = SIPCommSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = SIPCommSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(SIPCommSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public void loadSkin() {
        this.horizontalDivider = ImageLoader.getImage(ImageLoader.SPLITPANE_HORIZONTAL);
        this.verticalDivider = ImageLoader.getImage(ImageLoader.SPLITPANE_VERTICAL);
    }

    public class DividerLayout
    implements LayoutManager {
        @Override
        public void layoutContainer(Container c) {
            if (SIPCommSplitPaneDivider.this.leftButton != null && SIPCommSplitPaneDivider.this.rightButton != null && c == SIPCommSplitPaneDivider.this) {
                Dimension leftSize = SIPCommSplitPaneDivider.this.leftButton.getPreferredSize();
                Dimension rightSize = SIPCommSplitPaneDivider.this.rightButton.getPreferredSize();
                if (SIPCommSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SIPCommSplitPaneDivider.this.getInsets();
                    if (insets == null) {
                        insets = new Insets(0, 0, 0, 0);
                    }
                    if (SIPCommSplitPaneDivider.this.orientation == 0) {
                        int blockSize = SIPCommSplitPaneDivider.this.getDividerSize() - (insets.left + insets.right);
                        int y = (c.getHeight() - blockSize) / 2;
                        SIPCommSplitPaneDivider.this.leftButton.setBounds(insets.left + leftSize.width, y, leftSize.width, leftSize.height);
                        SIPCommSplitPaneDivider.this.rightButton.setBounds(insets.left * 2 + leftSize.width + rightSize.width, y, rightSize.width, rightSize.height);
                    } else {
                        int blockSize = SIPCommSplitPaneDivider.this.getDividerSize() - (insets.top + insets.bottom);
                        int x = (c.getWidth() - blockSize) / 2;
                        SIPCommSplitPaneDivider.this.leftButton.setBounds(x, insets.top + leftSize.height, leftSize.width, leftSize.height);
                        SIPCommSplitPaneDivider.this.rightButton.setBounds(x, insets.top * 2 + leftSize.height + rightSize.height, rightSize.width, rightSize.height);
                    }
                } else {
                    SIPCommSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SIPCommSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }
}

