/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.propertieseditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.propertieseditor.PropertiesEditorActivator;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class NewPropertyDialog
extends SIPCommDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ConfigurationService confService = PropertiesEditorActivator.getConfigurationService();
    private ResourceManagementService resourceManagementService = PropertiesEditorActivator.getResourceManagementService();
    private JButton okButton = new JButton(this.resourceManagementService.getI18NString("service.gui.OK"));
    private JButton cancelButton = new JButton(this.resourceManagementService.getI18NString("service.gui.CANCEL"));
    private JTextField propertyNameTextField = new JTextField();
    private JTextField propertyValueTextField = new JTextField();
    private JLabel propertyNameLabel = new JLabel(this.resourceManagementService.getI18NString("service.gui.NAME") + ": ");
    private JLabel propertyValueLabel = new JLabel(this.resourceManagementService.getI18NString("service.gui.VALUE") + ": ");
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private JPanel dataPanel = new TransparentPanel((LayoutManager)new GridBagLayout());

    public NewPropertyDialog() {
        this.setTitle(this.resourceManagementService.getI18NString("plugin.propertieseditor.NEW_PROPERTY_TITLE"));
        TransparentPanel fields = new TransparentPanel((LayoutManager)new BorderLayout());
        fields.setPreferredSize(new Dimension(450, 150));
        this.getContentPane().add((Component)fields);
        fields.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        fields.add((Component)this.dataPanel, "North");
        fields.add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        GridBagConstraints first = new GridBagConstraints();
        first.gridx = 0;
        first.gridy = 0;
        first.weightx = 0.0;
        first.anchor = 21;
        first.gridwidth = 1;
        first.insets = new Insets(2, 4, 2, 4);
        first.fill = 2;
        GridBagConstraints second = new GridBagConstraints();
        second.gridx = 1;
        second.gridy = 0;
        second.weightx = 2.0;
        second.anchor = 21;
        second.gridwidth = 1;
        second.insets = first.insets;
        second.fill = 2;
        this.dataPanel.add((Component)this.propertyNameLabel, first);
        this.dataPanel.add((Component)this.propertyNameTextField, second);
        first.gridy = ++second.gridy;
        this.dataPanel.add((Component)this.propertyValueLabel, first);
        this.dataPanel.add((Component)this.propertyValueTextField, second);
        this.propertyNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewPropertyDialog.this.okButton.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (NewPropertyDialog.this.propertyNameTextField.getText().length() == 0) {
                    NewPropertyDialog.this.okButton.setEnabled(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.okButton)) {
            this.confService.setProperty(this.propertyNameTextField.getText(), (Object)this.propertyValueTextField.getText());
        }
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }
}

