/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractDePacketizer;
import net.sf.fmj.utility.LoggerSingleton;

public class DePacketizer
extends AbstractDePacketizer {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};

    public DePacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("ALAW/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "ALAW DePacketizer";
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("ALAW/rtp")) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat result = new AudioFormat("alaw", inputCast.getSampleRate(), inputCast.getSampleSizeInBits(), inputCast.getChannels(), inputCast.getEndian(), inputCast.getSigned(), inputCast.getFrameSizeInBits(), inputCast.getFrameRate(), inputCast.getDataType());
        return new Format[]{result};
    }

    @Override
    public void open() {
    }

    @Override
    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    @Override
    public Format setOutputFormat(Format arg0) {
        return super.setOutputFormat(arg0);
    }
}

