/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.runner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import net.java.sip.communicator.slick.runner.ScTestRunner;
import net.java.sip.communicator.slick.runner.XmlFormatter;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;

public class SipCommunicatorSlickRunner
extends TestSuite
implements BundleActivator {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private static final String OUTPUT_DIR_PROPERTY_NAME = "net.java.sip.communicator.slick.runner.OUTPUT_DIR";
    private static final String DEFAULT_OUTPUT_DIR = "test-reports";
    private static final String OUTPUT_FILE_NAME = "sip-communicator.unit.test.reports.xml";
    private static final String TEST_LIST_PROPERTY_NAME = "net.java.sip.communicator.slick.runner.TEST_LIST";
    private BundleContext bundleContext = null;
    private int errCount = 0;
    private int runCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        this.logger.logEntry();
        try {
            File outputDir;
            this.bundleContext = bc;
            this.setName(((Object)((Object)this)).getClass().getName());
            String tests = System.getProperty(TEST_LIST_PROPERTY_NAME);
            if (tests == null || tests.trim().length() == 0) {
                tests = "";
            }
            this.logger.debug((Object)("specfied test list is: " + tests));
            StringTokenizer st = new StringTokenizer(tests);
            String[] ids = new String[st.countTokens()];
            int n = 0;
            while (st.hasMoreTokens()) {
                ids[n++] = st.nextToken().trim();
            }
            String outputDirName = System.getProperty(OUTPUT_DIR_PROPERTY_NAME);
            if (outputDirName == null || outputDirName.trim().length() == 0) {
                outputDirName = DEFAULT_OUTPUT_DIR;
            }
            if (!(outputDir = new File(outputDirName)).exists()) {
                outputDir.mkdirs();
            }
            for (int i = 0; i < ids.length; ++i) {
                this.logger.info((Object)("=========== Running tests in : " + ids[i] + " ==========="));
                TestSuite slick = this.getTestSuite(bc, ids[i]);
                this.logger.debug((Object)("with " + slick.countTestCases() + " tests."));
                File outputFile = new File(outputDir, "SC-TEST-" + ids[i] + ".xml");
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                this.logger.debug((Object)("specified reports file: " + outputFile.getCanonicalFile()));
                FileOutputStream out = new FileOutputStream(outputFile);
                XmlFormatter fmtr = new XmlFormatter(new PrintStream(out));
                TestResult res = ScTestRunner.run((Test)slick, fmtr);
                this.errCount += res.errorCount() + res.failureCount();
                this.runCount += res.runCount();
                out.flush();
                ((OutputStream)out).close();
            }
            this.logger.info((Object)"");
            this.logger.info((Object)"====================================================");
            this.logger.info((Object)("We ran " + this.runCount + " tests and encountered " + this.errCount + " errors and failures."));
            this.logger.info((Object)"====================================================");
            this.logger.info((Object)"");
            bc.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 1) {
                        try {
                            SipCommunicatorSlickRunner.this.bundleContext.getBundle(0L).stop();
                        }
                        catch (BundleException ex) {
                            SipCommunicatorSlickRunner.this.logger.error((Object)"Failed to gently shutdown Felix", (Throwable)ex);
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                System.exit(SipCommunicatorSlickRunner.this.errCount > 0 ? -1 : 0);
                            }
                        }).start();
                    }
                }
            });
        }
        finally {
            this.logger.logExit();
        }
    }

    public void stop(BundleContext bc) {
        this.logger.debug((Object)"Stopping!");
    }

    public TestSuite getTestSuite(BundleContext bc, final String id) {
        TestSuite suite;
        Test test;
        Object obj = null;
        try {
            ServiceReference[] srl = bc.getServiceReferences((String)null, "(service.pid=" + id + ")");
            if (srl == null || srl.length == 0) {
                obj = new TestCase("No id=" + id){

                    public void runTest() {
                        throw new IllegalArgumentException("No test with id=" + id);
                    }
                };
            }
            if (srl != null && srl.length != 1) {
                obj = new TestCase("Multiple id=" + id){

                    public void runTest() {
                        throw new IllegalArgumentException("More than one test with id=" + id);
                    }
                };
            }
            if (obj == null) {
                obj = bc.getService(srl[0]);
            }
        }
        catch (Exception e) {
            obj = new TestCase("Bad filter syntax id=" + id){

                public void runTest() {
                    throw new IllegalArgumentException("Bad syntax id=" + id);
                }
            };
        }
        if (!(obj instanceof Test)) {
            final TestCase oldObj = obj;
            obj = new TestCase("ClassCastException"){

                public void runTest() {
                    throw new ClassCastException("Service implements " + oldObj.getClass().getName() + " instead of " + Test.class.getName());
                }
            };
        }
        if ((test = (Test)obj) instanceof TestSuite) {
            suite = (TestSuite)test;
        } else {
            suite = new TestSuite(id);
            suite.addTest(test);
        }
        return suite;
    }
}

