/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.wizard.EncodingsPanel;
import net.java.sip.communicator.plugin.desktoputil.wizard.SecurityPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.AccountPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.ConnectionPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.IceConfigPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccRegWizzActivator;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountCreationFormService;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountRegistrationWizard;
import net.java.sip.communicator.plugin.jabberaccregwizz.NewAccount;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.plugin.jabberaccregwizz.TelephonyConfigPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.ValidatingPanel;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountRegistration;
import org.jitsi.util.StringUtils;
import org.osgi.framework.BundleContext;

public class JabberAccountRegistrationForm
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final AccountPanel accountPanel;
    private final ConnectionPanel connectionPanel;
    private final SecurityPanel securityPanel;
    private final IceConfigPanel iceConfigPanel;
    private final TelephonyConfigPanel telephonyConfigPanel;
    private final EncodingsPanel encodingsPanel;
    private boolean isModification;
    private final JabberAccountRegistrationWizard wizard;
    private final JTabbedPane tabbedPane = new SIPCommTabbedPane();
    private List<ValidatingPanel> validatingPanels = new ArrayList<ValidatingPanel>();

    public JabberAccountRegistrationForm(JabberAccountRegistrationWizard wizard) {
        super((LayoutManager)new BorderLayout());
        this.wizard = wizard;
        this.accountPanel = new AccountPanel(this);
        this.connectionPanel = new ConnectionPanel(this);
        this.securityPanel = new SecurityPanel(this.getRegistration().getSecurityRegistration(), false);
        this.iceConfigPanel = new IceConfigPanel();
        this.telephonyConfigPanel = new TelephonyConfigPanel();
        this.encodingsPanel = new EncodingsPanel();
    }

    void init() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JabberAccountCreationFormService createService = this.getCreateAccountService();
        if (createService != null) {
            createService.clear();
        }
        if (!JabberAccRegWizzActivator.isAdvancedAccountConfigDisabled()) {
            this.accountPanel.setSimpleForm(false);
            if (this.accountPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.ACCOUNT"), (Component)((Object)this.accountPanel));
            }
            if (this.connectionPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.CONNECTION"), (Component)((Object)this.connectionPanel));
            }
            if (this.securityPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.SECURITY"), (Component)this.securityPanel);
            }
            if (this.iceConfigPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.ICE"), (Component)((Object)this.iceConfigPanel));
            }
            if (this.telephonyConfigPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.TELEPHONY"), (Component)((Object)this.telephonyConfigPanel));
            }
            if (this.encodingsPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("plugin.jabberaccregwizz.ENCODINGS"), (Component)this.encodingsPanel);
            }
            if (this.tabbedPane.getParent() != this) {
                this.add(this.tabbedPane, "North");
            }
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.add((Component)((Object)this.accountPanel), "North");
        }
    }

    void setServerFieldAccordingToUIN(String userName) {
        if (!this.wizard.isModification() && !this.wizard.getRegistration().isServerOverridden()) {
            this.connectionPanel.setServerAddress(JabberAccountRegistrationForm.getServerFromUserName(userName));
        }
    }

    private void setNextFinishButtonEnabled(boolean isEnabled) {
        JabberAccRegWizzActivator.getUIService().getAccountRegWizardContainer().setNextFinishButtonEnabled(isEnabled);
    }

    void reValidateInput() {
        for (ValidatingPanel panel : this.validatingPanels) {
            if (panel.isValidated()) continue;
            this.setNextFinishButtonEnabled(false);
            return;
        }
        this.setNextFinishButtonEnabled(true);
    }

    public void addValidatingPanel(ValidatingPanel panel) {
        this.validatingPanels.add(panel);
    }

    static String getServerFromUserName(String userName) {
        int delimIndex = userName.indexOf("@");
        if (delimIndex != -1) {
            return userName.substring(delimIndex + 1);
        }
        return null;
    }

    public static String getUserFromUserName(String userName) {
        int delimIndex = userName.indexOf("@");
        return delimIndex == -1 ? userName : userName.substring(0, delimIndex);
    }

    String getServerAddress() {
        return this.wizard.getRegistration().getServerAddress();
    }

    public boolean isModification() {
        return this.isModification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean commitPage(JabberAccountRegistration registration) {
        String priority;
        String userID = null;
        char[] password = null;
        String serverAddress = null;
        String serverPort = null;
        if (this.accountPanel.isCreateAccount()) {
            NewAccount newAccount = this.getCreateAccountService().createAccount();
            if (newAccount == null) return false;
            userID = newAccount.getUserName();
            password = newAccount.getPassword();
            serverAddress = newAccount.getServerAddress();
            serverPort = newAccount.getServerPort();
            if (serverAddress == null) {
                this.setServerFieldAccordingToUIN(userID);
            }
        } else {
            userID = this.accountPanel.getUsername();
            if (userID == null || userID.trim().length() == 0) {
                throw new IllegalStateException("No user ID provided.");
            }
            if (userID.indexOf(64) < 0 && registration.getDefaultUserSufix() != null) {
                userID = userID + '@' + registration.getDefaultUserSufix();
            }
            password = this.accountPanel.getPassword();
            serverAddress = this.connectionPanel.getServerAddress();
            serverPort = this.connectionPanel.getServerPort();
        }
        registration.setUserID(userID);
        registration.setRememberPassword(this.accountPanel.isRememberPassword());
        registration.setPassword(new String(password));
        registration.setTlsClientCertificate(this.connectionPanel.getClientTlsCertificateId());
        registration.setServerAddress(serverAddress);
        registration.setServerOverridden(this.connectionPanel.isServerOverridden());
        registration.setSendKeepAlive(this.connectionPanel.isSendKeepAlive());
        registration.setGmailNotificationEnabled(this.connectionPanel.isGmailNotificationsEnabled());
        registration.setGoogleContactsEnabled(this.connectionPanel.isGoogleContactsEnabled());
        registration.setResourceAutogenerated(this.connectionPanel.isAutogenerateResourceEnabled());
        registration.setResource(this.connectionPanel.getResource());
        if (serverPort != null) {
            registration.setServerPort(serverPort);
        }
        if (!StringUtils.isNullOrEmpty((String)(priority = this.connectionPanel.getPriority()))) {
            registration.setPriority(Integer.parseInt(priority));
        }
        registration.setDTMFMethod(this.connectionPanel.getDTMFMethod());
        registration.setDtmfMinimalToneDuration(this.connectionPanel.getDtmfMinimalToneDuration());
        this.securityPanel.commitPanel(registration.getSecurityRegistration());
        registration.setUseIce(this.iceConfigPanel.isUseIce());
        registration.setAutoDiscoverStun(this.iceConfigPanel.isAutoDiscoverStun());
        registration.setUseDefaultStunServer(this.iceConfigPanel.isUseDefaultStunServer());
        registration.getAdditionalStunServers().clear();
        List<StunServerDescriptor> stunServers = this.iceConfigPanel.getAdditionalStunServers();
        for (StunServerDescriptor descriptor : stunServers) {
            registration.addStunServer(descriptor);
        }
        registration.setUseJingleNodes(this.iceConfigPanel.isUseJingleNodes());
        registration.setAutoDiscoverJingleNodes(this.iceConfigPanel.isAutoDiscoverJingleNodes());
        registration.getAdditionalJingleNodes().clear();
        List<JingleNodeDescriptor> jingleNodes = this.iceConfigPanel.getAdditionalJingleNodes();
        for (JingleNodeDescriptor descriptor : jingleNodes) {
            registration.addJingleNodes(descriptor);
        }
        registration.setUseUPNP(this.iceConfigPanel.isUseUPNP());
        registration.setAllowNonSecure(this.connectionPanel.isAllowNonSecure());
        registration.setDisableCarbon(this.connectionPanel.isCarbonDisabled());
        registration.setDisableJingle(this.telephonyConfigPanel.isJingleDisabled());
        registration.setTelephonyDomainBypassCaps(this.telephonyConfigPanel.getTelephonyDomainBypassCaps());
        registration.setOverridePhoneSufix(this.telephonyConfigPanel.getTelephonyDomain());
        this.encodingsPanel.commitPanel(registration.getEncodingsRegistration());
        return true;
    }

    public void loadAccount(JabberAccountRegistration accountReg) {
        this.accountPanel.setUsername(accountReg.getUserID());
        this.accountPanel.userIDField.setEnabled(false);
        String password = accountReg.getPassword();
        this.accountPanel.setPassword(password);
        this.accountPanel.setRememberPassword(password != null);
        String serverAddress = accountReg.getServerAddress();
        this.accountPanel.showChangePasswordPanel(true);
        this.connectionPanel.setServerAddress(serverAddress);
        this.connectionPanel.setClientTlsCertificateId(accountReg.getTlsClientCertificate());
        String serverPort = String.valueOf(accountReg.getServerPort());
        this.connectionPanel.setServerPort(serverPort);
        this.connectionPanel.setSendKeepAlive(accountReg.isSendKeepAlive());
        this.connectionPanel.setGmailNotificationsEnabled(accountReg.isGmailNotificationEnabled());
        this.connectionPanel.setGoogleContactsEnabled(accountReg.isGoogleContactsEnabled());
        this.connectionPanel.setResource(accountReg.getResource());
        this.connectionPanel.setAutogenerateResource(accountReg.isResourceAutogenerated());
        this.connectionPanel.setPriority(String.valueOf(accountReg.getPriority()));
        this.connectionPanel.setDTMFMethod(accountReg.getDTMFMethod());
        this.connectionPanel.setDtmfMinimalToneDuration(accountReg.getDtmfMinimalToneDuration());
        this.securityPanel.loadAccount(accountReg.getSecurityRegistration());
        this.iceConfigPanel.setUseIce(accountReg.isUseIce());
        this.iceConfigPanel.setAutoDiscoverStun(accountReg.isAutoDiscoverStun());
        this.iceConfigPanel.setUseDefaultStunServer(accountReg.isUseDefaultStunServer());
        List stunServers = accountReg.getAdditionalStunServers();
        this.iceConfigPanel.removeAllStunServer();
        for (StunServerDescriptor stunServer : stunServers) {
            this.iceConfigPanel.addStunServer(stunServer);
        }
        this.iceConfigPanel.setUseJingleNodes(accountReg.isUseJingleNodes());
        this.iceConfigPanel.setAutoDiscoverJingleNodes(accountReg.isAutoDiscoverJingleNodes());
        this.iceConfigPanel.removeAllJingleNodes();
        List jingleNodes = accountReg.getAdditionalJingleNodes();
        for (JingleNodeDescriptor jingleNode : jingleNodes) {
            this.iceConfigPanel.addJingleNodes(jingleNode);
        }
        this.iceConfigPanel.setUseUPNP(accountReg.isUseUPNP());
        this.connectionPanel.setAllowNonSecure(accountReg.isAllowNonSecure());
        this.connectionPanel.setDisableCarbon(accountReg.isCarbonDisabled());
        this.connectionPanel.setServerOverridden(accountReg.isServerOverridden());
        this.telephonyConfigPanel.setDisableJingle(accountReg.isJingleDisabled());
        this.telephonyConfigPanel.setTelephonyDomain(accountReg.getOverridePhoneSuffix());
        this.telephonyConfigPanel.setTelephonyDomainBypassCaps(accountReg.getTelephonyDomainBypassCaps());
        this.encodingsPanel.loadAccount(accountReg.getEncodingsRegistration());
    }

    public Component getSimpleForm() {
        JabberAccountCreationFormService createAccountService = this.getCreateAccountService();
        if (createAccountService != null) {
            createAccountService.clear();
        }
        this.accountPanel.setSimpleForm(true);
        return this.accountPanel;
    }

    public void setModification(boolean isModification) {
        this.isModification = isModification;
    }

    public String getUsernameExample() {
        return this.wizard.getUserNameExample();
    }

    public void webSignup() {
        this.wizard.webSignup();
    }

    public boolean isWebSignupSupported() {
        return this.wizard.isWebSignupSupported();
    }

    public JabberAccountCreationFormService getCreateAccountService() {
        return null;
    }

    protected String getUsernameLabel() {
        return this.wizard.getUsernameLabel();
    }

    public JabberAccountRegistration getRegistration() {
        return this.wizard.getRegistration();
    }

    protected String getCreateAccountButtonLabel() {
        return this.wizard.getCreateAccountButtonLabel();
    }

    protected String getCreateAccountLabel() {
        return this.wizard.getCreateAccountLabel();
    }

    protected String getExistingAccountLabel() {
        return this.wizard.getExistingAccountLabel();
    }

    protected String getHomeLinkLabel() {
        return this.wizard.getHomeLinkLabel();
    }

    private static String loadStunPassword(AccountID accountID, String namePrefix) {
        ProtocolProviderFactory providerFactory = JabberAccRegWizzActivator.getJabberProtocolProviderFactory();
        String password = null;
        String className = providerFactory.getClass().getName();
        String packageSourceName = className.substring(0, className.lastIndexOf(46));
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix((BundleContext)JabberAccRegWizzActivator.bundleContext, (AccountID)accountID, (String)packageSourceName);
        CredentialsStorageService credentialsService = JabberAccRegWizzActivator.getCredentialsService();
        try {
            password = credentialsService.loadPassword(accountPrefix + "." + namePrefix);
        }
        catch (Exception e) {
            return null;
        }
        return password;
    }

    public JabberAccountRegistrationWizard getWizard() {
        return this.wizard;
    }
}

